/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.sorcery;

import com.binaris.wizardry.api.content.data.ArcaneLockData;
import com.binaris.wizardry.api.content.event.EBPlayerBreakBlockEvent;
import com.binaris.wizardry.api.content.event.EBPlayerUseBlockEvent;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ArcaneLockSpell
extends RaySpell {
    public static void onPlayerUseBlock(EBPlayerUseBlockEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        BlockEntity blockEntity = event.getLevel().m_7702_(event.getPos());
        if (!(blockEntity instanceof BaseContainerBlockEntity)) {
            return;
        }
        BaseContainerBlockEntity containerBlock = (BaseContainerBlockEntity)blockEntity;
        ArcaneLockData data = Services.OBJECT_DATA.getArcaneLockData((BlockEntity)containerBlock);
        if (data == null) {
            return;
        }
        if (data.isArcaneLocked() && !data.getArcaneLockOwnerUUID().equals(event.getPlayer().m_20148_())) {
            event.getPlayer().m_5661_((Component)Component.m_237115_((String)"spell.ebwizardry.arcane_lock.not_owning").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
            event.setCanceled(true);
        }
    }

    public static void onPlayerBreakBlock(EBPlayerBreakBlockEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        BlockEntity blockEntity = event.getLevel().m_7702_(event.getPos());
        if (!(blockEntity instanceof BaseContainerBlockEntity)) {
            return;
        }
        BaseContainerBlockEntity containerBlock = (BaseContainerBlockEntity)blockEntity;
        ArcaneLockData data = Services.OBJECT_DATA.getArcaneLockData((BlockEntity)containerBlock);
        if (data == null) {
            return;
        }
        if (data.isArcaneLocked() && !data.getArcaneLockOwnerUUID().equals(event.getPlayer().m_20148_())) {
            event.getPlayer().m_5661_((Component)Component.m_237115_((String)"spell.ebwizardry.arcane_lock.not_owning").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
            event.setCanceled(true);
        }
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        BlockPos pos;
        LivingEntity livingEntity = ctx.caster();
        if (!(livingEntity instanceof Player)) {
            return false;
        }
        Player player = (Player)livingEntity;
        if (!ctx.world().f_46443_ && this.toggleLock(ctx, pos = blockHit.m_82425_(), player)) {
            BlockPos otherHalf = ArcaneLockSpell.getConnectedChest(ctx.world(), pos);
            if (otherHalf != null) {
                this.toggleLock(ctx, otherHalf, player);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return false;
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        return false;
    }

    private boolean toggleLock(CastContext ctx, BlockPos pos, Player player) {
        BlockEntity blockEntity = ctx.world().m_7702_(pos);
        if (!(blockEntity instanceof BaseContainerBlockEntity)) {
            return false;
        }
        BaseContainerBlockEntity containerBlock = (BaseContainerBlockEntity)blockEntity;
        ArcaneLockData data = Services.OBJECT_DATA.getArcaneLockData((BlockEntity)containerBlock);
        if (data == null) {
            return false;
        }
        if (data.isArcaneLocked()) {
            if (data.getArcaneLockOwnerUUID().equals(player.m_20148_())) {
                data.setArcaneLockOwner(null);
                player.m_5661_((Component)Component.m_237115_((String)"spell.ebwizardry.arcane_lock.unlocking").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)"spell.ebwizardry.arcane_lock.not_owning").m_130940_(this.getElement().getColor()), true);
            return false;
        }
        data.setArcaneLockOwner(player.m_20148_().toString());
        blockEntity.m_6596_();
        ctx.world().m_7260_(pos, ctx.world().m_8055_(pos), ctx.world().m_8055_(pos), 3);
        player.m_5661_((Component)Component.m_237115_((String)"spell.ebwizardry.arcane_lock.locking").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
        return true;
    }

    private static BlockPos getConnectedChest(Level level, BlockPos pos) {
        Block block = level.m_8055_(pos).m_60734_();
        if (!(block instanceof ChestBlock)) {
            return null;
        }
        ChestBlock chest = (ChestBlock)block;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos pos1 = pos.m_121955_(direction.m_122436_());
            if (level.m_8055_(pos1).m_60734_() != chest) continue;
            return pos1;
        }
        return null;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.SORCERY, SpellType.UTILITY, SpellAction.POINT, 50, 0, 100).add(DefaultProperties.RANGE, Float.valueOf(8.0f)).build();
    }
}

