/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.sorcery;

import com.binaris.wizardry.api.content.data.ConjureData;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.ConjureItemSpell;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBItems;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ConjureArmor
extends ConjureItemSpell {
    private static final Map<EquipmentSlot, Item> SPECTRAL_ARMOUR_MAP = ImmutableMap.of((Object)EquipmentSlot.HEAD, (Object)EBItems.SPECTRAL_HELMET.get(), (Object)EquipmentSlot.CHEST, (Object)EBItems.SPECTRAL_CHESTPLATE.get(), (Object)EquipmentSlot.LEGS, (Object)EBItems.SPECTRAL_LEGGINGS.get(), (Object)EquipmentSlot.FEET, (Object)EBItems.SPECTRAL_BOOTS.get());

    public ConjureArmor() {
        super(EBItems.SPECTRAL_HELMET.get());
        ConjureArmor.registerSupportedItem(EBItems.SPECTRAL_CHESTPLATE.get());
        ConjureArmor.registerSupportedItem(EBItems.SPECTRAL_LEGGINGS.get());
        ConjureArmor.registerSupportedItem(EBItems.SPECTRAL_BOOTS.get());
    }

    @Override
    protected boolean conjureItem(PlayerCastContext ctx) {
        boolean flag = false;
        for (EquipmentSlot slot : InventoryUtil.ARMOR_SLOTS) {
            if (!ctx.caster().m_6844_(slot).m_41619_() && InventoryUtil.doesPlayerHaveItem(ctx.caster(), SPECTRAL_ARMOUR_MAP.get(slot))) continue;
            ItemStack armor = new ItemStack((ItemLike)SPECTRAL_ARMOUR_MAP.get(slot));
            armor = this.addItemExtras(ctx, armor);
            ConjureData data = Services.OBJECT_DATA.getConjureData(armor);
            int duration = this.property(DefaultProperties.ITEM_LIFETIME);
            long currentGameTime = ctx.world().m_46467_();
            data.setExpireTime(currentGameTime + (long)duration);
            data.setDuration(duration);
            data.setSummoned(true);
            ctx.caster().m_8061_(slot, armor);
            flag = true;
        }
        return flag;
    }
}

