/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.sorcery;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PhaseStep
extends Spell {
    public static final SpellProperty<Integer> WALL_THICKNESS = SpellProperty.intProperty("wall_thickness", 1);

    @Override
    public boolean cast(PlayerCastContext ctx) {
        Player caster = ctx.caster();
        Level world = ctx.world();
        boolean teleportMount = caster.m_20202_() != null && EBAccessoriesIntegration.isEquipped(caster, EBItems.CHARM_MOUNT_TELEPORTING.get());
        double range = this.property(DefaultProperties.RANGE).floatValue();
        int maxThickness = this.property(WALL_THICKNESS);
        Vec3 start = caster.m_146892_();
        Vec3 direction = caster.m_20154_();
        if (world.f_46443_) {
            for (int i = 0; i < 10; ++i) {
                double x = caster.m_20185_();
                double y = caster.m_20186_() + (double)(2.0f * world.f_46441_.m_188501_());
                double z = caster.m_20189_();
                world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, world.f_46441_.m_188500_() - 0.5, world.f_46441_.m_188500_() - 0.5, world.f_46441_.m_188500_() - 0.5);
            }
        }
        Player subject = teleportMount ? caster.m_20202_() : caster;
        BlockPos lastChecked = null;
        int wallThickness = 0;
        boolean inWall = false;
        for (double dist = 1.0; dist <= range; dist += 0.5) {
            boolean isBlocked;
            Vec3 checkPoint = start.m_82549_(direction.m_82490_(dist));
            BlockPos checkPos = BlockPos.m_274446_((Position)checkPoint);
            if (lastChecked != null && lastChecked.equals((Object)checkPos)) continue;
            lastChecked = checkPos;
            boolean bl = isBlocked = !BlockUtil.isBlockPassable(world, checkPos) || !BlockUtil.isBlockPassable(world, checkPos.m_7494_());
            if (isBlocked) {
                if (!inWall) {
                    inWall = true;
                    wallThickness = 1;
                } else {
                    ++wallThickness;
                }
                if (wallThickness <= maxThickness) continue;
                break;
            }
            if (inWall) {
                Vec3 dest = new Vec3((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_(), (double)checkPos.m_123343_() + 0.5);
                if (this.attemptTeleport(world, (Entity)subject, dest, teleportMount, caster)) {
                    return true;
                }
                inWall = false;
                wallThickness = 0;
                continue;
            }
            if (!(dist >= range - 0.5)) continue;
            Vec3 destination = new Vec3((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_(), (double)checkPos.m_123343_() + 0.5);
            return this.attemptTeleport(world, (Entity)subject, destination, teleportMount, caster);
        }
        return false;
    }

    protected boolean attemptTeleport(Level world, Entity toTeleport, Vec3 destination, boolean teleportMount, Player caster) {
        Vec3 resolved = EntityUtil.findSpaceForTeleport(toTeleport, destination, teleportMount);
        if (resolved == null) {
            return false;
        }
        this.playSound(world, (LivingEntity)caster, 0, -1);
        if (!teleportMount && caster.m_20202_() != null) {
            caster.m_8127_();
        }
        if (!world.f_46443_) {
            if (toTeleport instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)toTeleport;
                sp.m_6021_(resolved.f_82479_, resolved.f_82480_, resolved.f_82481_);
            } else {
                toTeleport.m_6034_(resolved.f_82479_, resolved.f_82480_, resolved.f_82481_);
            }
        }
        this.playSound(world, (LivingEntity)caster, 0, -1);
        return true;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.SORCERY, SpellType.UTILITY, SpellAction.POINT, 35, 0, 40).add(WALL_THICKNESS).add(DefaultProperties.RANGE, Float.valueOf(8.0f)).build();
    }
}

