/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.sorcery;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SpeedTime
extends Spell {
    public static final SpellProperty<Float> TIME_INCREMENT = SpellProperty.floatProperty("time_increment", 30.0f);
    public static final SpellProperty<Integer> EXTRA_TICKS = SpellProperty.intProperty("extra_ticks", 1);

    public SpeedTime() {
        this.soundValues(0.4f, 1.0f, 0.0f);
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        Level world = ctx.world();
        Player caster = ctx.caster();
        boolean didAnything = false;
        float blastMod = ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
        if (!world.f_46443_) {
            long advance = (long)(this.property(TIME_INCREMENT).floatValue() * blastMod);
            ((ServerLevel)world).m_8615_(world.m_46468_() + advance);
            didAnything = true;
        }
        double radius = (float)this.property(DefaultProperties.EFFECT_RADIUS).intValue() * blastMod;
        int potencyLevel = (int)(((ctx.modifiers().get("potency") - 1.0f) * 2.0f + 1.0f) * (float)this.property(EXTRA_TICKS).intValue());
        List<Entity> entities = EntityUtil.getEntitiesWithinRadius(radius, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), world, Entity.class);
        if (!entities.isEmpty()) {
            entities.removeIf(e -> e instanceof Player);
            if (!entities.isEmpty()) {
                for (int i = 0; i < potencyLevel; ++i) {
                    for (Entity e2 : entities) {
                        e2.m_8119_();
                    }
                }
                didAnything = true;
            }
        }
        if (!world.f_46443_) {
            List<BlockPos> sphere = BlockUtil.getBlockSphere(caster.m_20183_(), radius);
            for (BlockPos pos : sphere) {
                BlockState state = world.m_8055_(pos);
                if (!state.m_60823_()) continue;
                for (int i = 0; i < potencyLevel; ++i) {
                    state.m_222972_((ServerLevel)world, pos, world.f_46441_);
                }
            }
        }
        if (world.f_46443_) {
            double x = caster.m_20185_() + 2.0;
            double y = caster.m_20186_() + (double)(caster.m_20206_() / 2.0f);
            double z = caster.m_20189_();
            for (int i = 0; i < 2; ++i) {
                ParticleBuilder.create(EBParticles.SPARKLE, world.f_46441_, x, y, z, 2.0, false).velocity(-0.25, 0.0, 0.0).time(16).color(1.0f, 1.0f, 1.0f).spawn(world);
                ParticleBuilder.create(EBParticles.FLASH, world.f_46441_, x, y, z, 2.0, false).velocity(-0.25, 0.0, 0.0).time(16).scale(0.5f).color(0.6f + world.f_46441_.m_188501_() * 0.4f, 0.6f + world.f_46441_.m_188501_() * 0.4f, 0.6f + world.f_46441_.m_188501_() * 0.4f).spawn(world);
            }
        }
        this.playSound(world, (LivingEntity)caster, ctx.castingTicks(), -1);
        return didAnything;
    }

    @Override
    protected void playSound(Level world, LivingEntity entity, int castTicks, int duration) {
        this.playSoundLoop(world, entity, castTicks);
    }

    @Override
    protected void playSound(Level world, double x, double y, double z, int ticksInUse, int duration) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean isInstantCast() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.SORCERY, SpellType.UTILITY, SpellAction.POINT_UP, 15, 0, 0).add(DefaultProperties.EFFECT_RADIUS).add(TIME_INCREMENT).add(EXTRA_TICKS).build();
    }
}

