/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core;

import com.binaris.wizardry.api.content.data.WizardData;
import com.binaris.wizardry.api.content.event.EBLivingHurtEvent;
import com.binaris.wizardry.core.EBConfig;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public final class AllyDesignation {
    private AllyDesignation() {
    }

    public static boolean isAllied(LivingEntity allyOf, Entity possibleAlly) {
        OwnableEntity ownable;
        LivingEntity owner;
        if (allyOf instanceof OwnableEntity && (owner = (ownable = (OwnableEntity)allyOf).m_269323_()) instanceof LivingEntity) {
            LivingEntity livingOwner = owner;
            if (owner == possibleAlly || AllyDesignation.isAllied(livingOwner, possibleAlly)) {
                return true;
            }
        }
        if (allyOf instanceof Player) {
            Player possibleAllyPlayer;
            Player allyPlayer = (Player)allyOf;
            if (possibleAlly instanceof Player && AllyDesignation.isPlayerAlly(allyPlayer, possibleAllyPlayer = (Player)possibleAlly)) {
                return true;
            }
        }
        if (possibleAlly instanceof OwnableEntity) {
            Player playerAlly;
            OwnableEntity pet = (OwnableEntity)possibleAlly;
            if (pet.m_269323_() == allyOf) {
                return true;
            }
            return allyOf instanceof Player && AllyDesignation.isOwnerAlly(playerAlly = (Player)allyOf, pet);
        }
        return false;
    }

    public static boolean isValidTarget(@Nullable Entity attacker, @Nullable Entity target) {
        LivingEntity living;
        LivingEntity owner;
        OwnableEntity ownable;
        if (target == null || target == attacker) {
            return false;
        }
        if (attacker == null) {
            return true;
        }
        if (attacker instanceof OwnableEntity && !AllyDesignation.isValidTarget((Entity)(ownable = (OwnableEntity)attacker).m_269323_(), target)) {
            return false;
        }
        if (EBConfig.passiveMobsAreAllies && target.m_6095_().m_20674_().m_21609_()) {
            return false;
        }
        if (target instanceof OwnableEntity && ((owner = (ownable = (OwnableEntity)target).m_269323_()) == attacker || attacker instanceof LivingEntity && (living = (LivingEntity)attacker).m_271686_() != owner)) {
            return false;
        }
        if (attacker instanceof Player) {
            OwnableEntity ownable2;
            Player attackerPlayer = (Player)attacker;
            if (target instanceof Player) {
                Player playerTarget = (Player)target;
                return !Services.OBJECT_DATA.getWizardData(attackerPlayer).isPlayerAlly(playerTarget);
            }
            return !(target instanceof OwnableEntity) || !AllyDesignation.isOwnerAlly(attackerPlayer, ownable2 = (OwnableEntity)target);
        }
        return true;
    }

    public static void onLivingHurt(EBLivingHurtEvent event) {
        Player playerDirect;
        block10: {
            block9: {
                if (event.getSource() == null) {
                    return;
                }
                Entity directEntity = event.getSource().m_7640_();
                if (!(directEntity instanceof Player)) break block9;
                playerDirect = (Player)directEntity;
                if (EBDamageSources.isMagic(event.getSource())) break block10;
            }
            return;
        }
        LivingEntity damagedEntity = event.getDamagedEntity();
        if (damagedEntity instanceof Player) {
            Player playerSource = (Player)damagedEntity;
            if (EBConfig.blockPlayersAlliesDamage && AllyDesignation.isPlayerAlly(playerDirect, playerSource)) {
                event.setCanceled(true);
            }
        } else if (EBConfig.blockOwnedAlliesDamage && AllyDesignation.isAllied((LivingEntity)playerDirect, (Entity)damagedEntity)) {
            event.setCanceled(true);
        }
    }

    public static boolean isPlayerAlly(Player allyOf, Player possibleAlly) {
        WizardData data = Services.OBJECT_DATA.getWizardData(allyOf);
        return data.isPlayerAlly(possibleAlly);
    }

    public static boolean isOwnerAlly(Player allyOf, OwnableEntity ownable) {
        boolean bl;
        WizardData data = Services.OBJECT_DATA.getWizardData(allyOf);
        LivingEntity owner = ownable.m_269323_();
        if (owner instanceof Player) {
            Player target = (Player)owner;
            bl = data.isPlayerAlly(target);
        } else {
            bl = data.isPlayerAlly(ownable.m_21805_());
        }
        return bl;
    }
}

