/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.event.EBLivingHurtEvent;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.item.WandItem;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class ArtifactUtils {
    private ArtifactUtils() {
    }

    public static boolean meleeRing(DamageSource source, Element element) {
        WandItem wand;
        LivingEntity living;
        Entity entity;
        return !source.m_269014_() && (entity = source.m_7639_()) instanceof LivingEntity && (entity = (living = (LivingEntity)entity).m_21205_().m_41720_()) instanceof WandItem && (wand = (WandItem)entity).getElement() == element;
    }

    public static boolean findMatchingWandAndCast(Player player, Spell spell) {
        return ArtifactUtils.findMatchingWandAndExecute(player, spell, wand -> {
            SpellModifiers modifiers = new SpellModifiers();
            if (((ISpellCastingItem)wand.m_41720_()).canCast((ItemStack)wand, spell, new PlayerCastContext(player.m_9236_(), player, InteractionHand.MAIN_HAND, 0, modifiers))) {
                ((ISpellCastingItem)wand.m_41720_()).cast((ItemStack)wand, spell, new PlayerCastContext(player.m_9236_(), player, InteractionHand.MAIN_HAND, 0, modifiers));
            }
        });
    }

    public static boolean findMatchingWandAndExecute(Player player, Spell spell, Consumer<? super ItemStack> action) {
        List<ItemStack> hotbar = InventoryUtil.getHotBarAndOffhand(player);
        Optional<ItemStack> stack = hotbar.stream().filter(s -> s.m_41720_() instanceof ISpellCastingItem && Arrays.asList(((ISpellCastingItem)s.m_41720_()).getSpells((ItemStack)s)).contains(spell)).findFirst();
        stack.ifPresent(action);
        return stack.isPresent();
    }

    public static void handleLightningEffect(Entity player, LivingEntity target, EBLivingHurtEvent event) {
        if (player.m_9236_().f_46443_) {
            ParticleBuilder.create(EBParticles.LIGHTNING).entity((Entity)event.getDamagedEntity()).pos(0.0, event.getDamagedEntity().m_20206_() / 2.0f, 0.0).target((Entity)target).spawn(player.m_9236_());
            ParticleBuilder.spawnShockParticles(player.m_9236_(), target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_());
        }
        target.m_6469_(MagicDamageSource.causeDirectMagicDamage(player, EBDamageSources.SHOCK), Spells.STATIC_AURA.property(DefaultProperties.DAMAGE).floatValue());
        target.m_5496_(EBSounds.SPELL_STATIC_AURA_RETALIATE.get(), 1.0f, player.m_9236_().f_46441_.m_188501_() * 0.4f + 1.5f);
    }
}

