/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core;

import com.binaris.wizardry.api.content.data.CastCommandData;
import com.binaris.wizardry.api.content.data.ConjureData;
import com.binaris.wizardry.api.content.data.ISpellVar;
import com.binaris.wizardry.api.content.data.ImbuementEnchantData;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.data.WizardData;
import com.binaris.wizardry.api.content.event.EBEntityJoinLevelEvent;
import com.binaris.wizardry.api.content.event.EBItemPlaceInContainerEvent;
import com.binaris.wizardry.api.content.event.EBItemTossEvent;
import com.binaris.wizardry.api.content.event.EBLivingDeathEvent;
import com.binaris.wizardry.api.content.event.EBLivingTick;
import com.binaris.wizardry.api.content.event.EBPlayerInteractEntityEvent;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.content.spell.abstr.ConjureItemSpell;
import com.binaris.wizardry.core.platform.Services;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public final class DataEvents {
    private static final int CONJURE_CHECK_INTERVAL = 20;
    private static final int IMBUEMENT_ENCHANTS_CHECK_INTERVAL = 20;

    private DataEvents() {
    }

    public static void onMinionTick(EBLivingTick event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (!Services.OBJECT_DATA.isMinion((Entity)mob)) {
            return;
        }
        Services.OBJECT_DATA.getMinionData(mob).tick();
    }

    public static void onConjureToss(EBItemTossEvent event) {
        ConjureData data;
        ItemStack stack = event.getStack();
        if (ConjureItemSpell.isSummoned(stack) && (data = Services.OBJECT_DATA.getConjureData(stack)) != null && data.isSummoned()) {
            event.setCanceled(true);
        }
    }

    public static void onConjureEntityDeath(EBLivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        InventoryUtil.getAllItems(player).stream().filter(ConjureItemSpell::isSummoned).forEach(stack -> stack.m_41774_(stack.m_41613_()));
    }

    public static void onConjureItemPlaceInContainer(EBItemPlaceInContainerEvent event) {
        ItemStack stack = event.getStack();
        if (ConjureItemSpell.isSummoned(stack) && !(event.getContainer() instanceof Inventory)) {
            event.setCanceled(true);
        }
    }

    public static void onPlayerTick(EBLivingTick event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_21224_()) {
            return;
        }
        DataEvents.spellDataTick(player);
        DataEvents.castCommandTick(player);
        DataEvents.conjureItemTick(player);
        DataEvents.recentSpells(player);
        DataEvents.temporaryEnchantmentTick(player);
    }

    private static void spellDataTick(Player player) {
        SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(player);
        Map<ISpellVar, Object> spellData = data.getSpellData();
        spellData.replaceAll((k, v) -> k.update(player, v));
        spellData.entrySet().removeIf(entry -> ((ISpellVar)entry.getKey()).canPurge(player, entry.getValue()));
    }

    public static void onMinionJoinLevel(EBEntityJoinLevelEvent event) {
        Mob mob;
        Entity entity = event.getEntity();
        if (entity instanceof Mob && Services.OBJECT_DATA.isMinion((Entity)(mob = (Mob)entity))) {
            Services.OBJECT_DATA.getMinionData(mob).markGoalRestart(true);
        }
    }

    public static void onPlayerInteractMinion(EBPlayerInteractEntityEvent event) {
        Mob mob;
        Entity entity = event.getTarget();
        if (entity instanceof Mob && Services.OBJECT_DATA.isMinion((Entity)(mob = (Mob)entity))) {
            event.setCanceled(true);
        }
    }

    private static void castCommandTick(Player player) {
        CastCommandData castData = Services.OBJECT_DATA.getCastCommandData(player);
        castData.tick();
    }

    private static void temporaryEnchantmentTick(Player player) {
        if (player.m_9236_().m_46467_() % 20L != 0L) {
            return;
        }
        long currentGameTime = player.m_9236_().m_46467_();
        for (ItemStack stack : InventoryUtil.getAllItems(player)) {
            Map<ResourceLocation, Long> tempEnchants;
            ImbuementEnchantData data;
            if (stack.m_41619_() || EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty() || (data = Services.OBJECT_DATA.getImbuementData(stack)) == null || (tempEnchants = data.getImbuements()).isEmpty()) continue;
            Map currentEnchants = EnchantmentHelper.m_44831_((ItemStack)stack);
            boolean changed = false;
            for (Map.Entry<ResourceLocation, Long> entry : tempEnchants.entrySet()) {
                Enchantment enchantment;
                long expireTime = entry.getValue();
                if (expireTime < 0L || currentGameTime < expireTime || (enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(entry.getKey())) == null) continue;
                currentEnchants.remove(enchantment);
                data.removeImbuement(enchantment);
                changed = true;
            }
            if (!changed) continue;
            EnchantmentHelper.m_44865_((Map)currentEnchants, (ItemStack)stack);
        }
    }

    private static void conjureItemTick(Player player) {
        if (player.f_19797_ % 20 != 0) {
            return;
        }
        long currentGameTime = player.m_9236_().m_46467_();
        InventoryUtil.getAllItems(player).stream().filter(ConjureItemSpell::isSummoned).forEach(stack -> DataEvents.checkAndExpireItem(stack, currentGameTime));
    }

    private static void checkAndExpireItem(ItemStack stack, long currentGameTime) {
        ConjureData data = Services.OBJECT_DATA.getConjureData(stack);
        if (data != null && data.hasExpired(currentGameTime)) {
            stack.m_41774_(1);
            data.setSummoned(false);
        }
    }

    private static void recentSpells(Player player) {
        WizardData data = Services.OBJECT_DATA.getWizardData(player);
        if (player.f_19797_ % 60 == 0) {
            long currentTime = player.m_9236_().m_46467_();
            data.removeRecentCasts(entry -> currentTime - (Long)entry.getValue() >= 1200L);
        }
    }
}

