/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core;

import com.binaris.wizardry.setup.registries.EBRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImbuementAltarRecipeBuilder
implements RecipeBuilder {
    private final Ingredient centerIngredient;
    private final Ingredient[] receptacleIngredients;
    private final Item result;
    private final int count;
    @Nullable
    private CompoundTag nbt;
    @Nullable
    private String group;

    private ImbuementAltarRecipeBuilder(Ingredient centerIngredient, Ingredient[] receptacleIngredients, ItemLike result, int count) {
        if (receptacleIngredients.length != 4) {
            throw new IllegalArgumentException("ImbuementAltarRecipe must have exactly 4 receptacle ingredients");
        }
        this.centerIngredient = centerIngredient;
        this.receptacleIngredients = receptacleIngredients;
        this.result = result.m_5456_();
        this.count = count;
    }

    public static ImbuementAltarRecipeBuilder imbuement(Ingredient centerIngredient, Ingredient receptacle, ItemLike result) {
        return new ImbuementAltarRecipeBuilder(centerIngredient, new Ingredient[]{receptacle, receptacle, receptacle, receptacle}, result, 1);
    }

    public static ImbuementAltarRecipeBuilder imbuement(Ingredient centerIngredient, Ingredient receptacle1, Ingredient receptacle2, Ingredient receptacle3, Ingredient receptacle4, ItemLike result) {
        return new ImbuementAltarRecipeBuilder(centerIngredient, new Ingredient[]{receptacle1, receptacle2, receptacle3, receptacle4}, result, 1);
    }

    public static ImbuementAltarRecipeBuilder imbuement(Ingredient centerIngredient, Ingredient receptacle1, Ingredient receptacle2, Ingredient receptacle3, Ingredient receptacle4, ItemLike result, int count) {
        return new ImbuementAltarRecipeBuilder(centerIngredient, new Ingredient[]{receptacle1, receptacle2, receptacle3, receptacle4}, result, count);
    }

    public ImbuementAltarRecipeBuilder withNbt(CompoundTag nbt) {
        this.nbt = nbt;
        return this;
    }

    @NotNull
    public ImbuementAltarRecipeBuilder unlockedBy(@NotNull String criterionName, @NotNull CriterionTriggerInstance criterionTrigger) {
        return this;
    }

    @NotNull
    public ImbuementAltarRecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    @NotNull
    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> finishedRecipeConsumer, @NotNull ResourceLocation recipeId) {
        finishedRecipeConsumer.accept(new Result(recipeId, this.group == null ? "" : this.group, this.centerIngredient, this.receptacleIngredients, this.result, this.count, this.nbt, recipeId.m_246208_("recipes/imbuement_altar/")));
    }

    static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient centerIngredient;
        private final Ingredient[] receptacleIngredients;
        private final Item result;
        private final int count;
        @Nullable
        private final CompoundTag nbt;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, String group, Ingredient centerIngredient, Ingredient[] receptacleIngredients, Item result, int count, @Nullable CompoundTag nbt, ResourceLocation advancementId) {
            this.id = id;
            this.group = group;
            this.centerIngredient = centerIngredient;
            this.receptacleIngredients = receptacleIngredients;
            this.result = result;
            this.count = count;
            this.nbt = nbt;
            this.advancementId = advancementId;
        }

        public void m_7917_(@NotNull JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("center", this.centerIngredient.m_43942_());
            JsonArray receptaclesArray = new JsonArray();
            for (Ingredient ingredient : this.receptacleIngredients) {
                receptaclesArray.add(ingredient.m_43942_());
            }
            json.add("receptacles", (JsonElement)receptaclesArray);
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            resultObject.addProperty("count", (Number)this.count);
            if (this.nbt != null) {
                resultObject.addProperty("nbt", this.nbt.toString());
            }
            json.add("result", (JsonElement)resultObject);
        }

        public RecipeSerializer<?> m_6637_() {
            return EBRecipeTypes.IMBUEMENT_ALTAR_SERIALIZER;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

