/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.core.platform.Services;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.Deserializers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PropertiesDataManager
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = Deserializers.m_78799_().create();
    protected static final Logger LOGGER = LogManager.getLogger();
    public static PropertiesDataManager INSTANCE;

    public PropertiesDataManager() {
        super(GSON, "spells");
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceList, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceList.entrySet()) {
            ResourceLocation location = entry.getKey();
            try {
                Spell spell = Services.REGISTRY_UTIL.getSpell(location);
                if (spell == null) {
                    LOGGER.warn("No spell found with ID {}, skipping loading of its properties", (Object)location);
                    continue;
                }
                SpellProperties properties = SpellProperties.fromJson(GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)location.toString()));
                if (properties == null) {
                    LOGGER.info("Skipping loading spell properties {} as it's serializer returned null", (Object)location);
                    continue;
                }
                spell.setProperties(properties);
            }
            catch (JsonParseException | IllegalArgumentException jsonParseException) {
                LOGGER.error("Parsing error loading spell properties {}", (Object)location, (Object)jsonParseException);
            }
            catch (Exception exception) {
                LOGGER.error("Unexpected error loading spell properties {}", (Object)location, (Object)exception);
            }
        }
    }
}

