/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core;

import com.binaris.wizardry.api.content.event.EBLivingDeathEvent;
import com.binaris.wizardry.api.content.event.EBLivingHurtEvent;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.core.IArtefactEffect;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.world.item.ItemStack;

public class QuickArtefactEffect
implements IArtefactEffect {
    private QuickArtefactEffect() {
    }

    public static IArtefactEffect spellPreCast(final BiPredicate<SpellCastEvent.Pre, ItemStack> predicate, final BiConsumer<SpellCastEvent.Pre, ItemStack> consumer) {
        return new QuickArtefactEffect(){

            @Override
            public void onSpellPreCast(SpellCastEvent.Pre event, ItemStack stack) {
                if (predicate.test(event, stack)) {
                    consumer.accept(event, stack);
                }
            }
        };
    }

    public static IArtefactEffect hurtEntity(final BiPredicate<EBLivingHurtEvent, ItemStack> predicate, final BiConsumer<EBLivingHurtEvent, ItemStack> consumer) {
        return new QuickArtefactEffect(){

            @Override
            public void onHurtEntity(EBLivingHurtEvent event, ItemStack stack) {
                if (predicate.test(event, stack)) {
                    consumer.accept(event, stack);
                }
            }
        };
    }

    public static IArtefactEffect death(final BiPredicate<EBLivingDeathEvent, ItemStack> predicate, final BiConsumer<EBLivingDeathEvent, ItemStack> consumer) {
        return new QuickArtefactEffect(){

            @Override
            public void onDeath(EBLivingDeathEvent event, ItemStack stack) {
                if (predicate.test(event, stack)) {
                    consumer.accept(event, stack);
                }
            }
        };
    }
}

