/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.gametest;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.content.blockentity.ArcaneWorkbenchBlockEntity;
import com.binaris.wizardry.content.item.BlankScrollItem;
import com.binaris.wizardry.content.item.CrystalItem;
import com.binaris.wizardry.content.item.SpellBookItem;
import com.binaris.wizardry.content.item.WandItem;
import com.binaris.wizardry.content.item.WizardArmorItem;
import com.binaris.wizardry.content.item.WizardArmorType;
import com.binaris.wizardry.content.menu.ArcaneWorkbenchMenu;
import com.binaris.wizardry.core.gametest.GST;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public final class ArcaneWorkbenchTest {
    private static final BlockPos WORKBENCH_POS = new BlockPos(1, 2, 1);
    private static final Vec3 PLAYER_POS = new Vec3(1.5, 2.0, 1.5);

    public static void applySpellsToWand(GameTestHelper helper, Item wand, Spell ... spells) {
        ItemStack wandStack;
        WandItem wandItem;
        block4: {
            block3: {
                if (!(wand instanceof WandItem)) break block3;
                wandItem = (WandItem)wand;
                if (spells.length != 0) break block4;
            }
            helper.m_177284_("Invalid parameters for applySpellsToWand test.");
            return;
        }
        ItemStack finalWandStack = wandStack = wand.m_7968_();
        List<Spell> validSpells = Arrays.stream(spells).filter(s -> wandItem.getTier((ItemStack)finalWandStack).level >= s.getTier().level).toList();
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, wandStack);
        for (int i = 0; i < validSpells.size(); ++i) {
            ctx.workbench.m_6836_(i, SpellUtil.spellBookItem(validSpells.get(i)));
        }
        ctx.menu.onApplyButtonPressed(ctx.player);
        wandStack = ctx.workbench.m_8020_(9);
        List<Spell> wandSpells = WandHelper.getSpells(wandStack);
        validSpells.forEach(spell -> GST.assertTrue(helper, "Wand %s should contain %s spell after applying.".formatted(wandItem, spell), wandSpells.contains(spell)));
    }

    public static void canUpgradeToNextTier(GameTestHelper helper, Item wand) {
        if (!(wand instanceof WandItem)) {
            helper.m_177284_("Invalid parameters for canUpgradeToNextTier test.");
            return;
        }
        WandItem wandItem = (WandItem)wand;
        ItemStack wandStack = wand.m_7968_();
        if (wandItem.getTier(wandStack) == SpellTiers.MASTER) {
            return;
        }
        SpellTier nextTier = wandItem.getTier(wandStack).next();
        WandHelper.setProgression(wandStack, nextTier.getProgression());
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, wandStack);
        ctx.workbench.m_6836_(10, SpellUtil.arcaneTomeItem(nextTier));
        ctx.menu.onApplyButtonPressed(ctx.player);
        wandStack = ctx.workbench.m_8020_(9);
        GST.assertEquals(helper, "Wand should upgrade to next tier.", nextTier, ((WandItem)wandStack.m_41720_()).getTier(wandStack));
        GST.assertEmpty(helper, "Upgrade item should be consumed.", ctx.workbench.m_8020_(10));
    }

    public static void putSpellOnBlankScroll(GameTestHelper helper, Spell spell) {
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, EBItems.BLANK_SCROLL.get().m_7968_());
        ctx.workbench.m_6836_(0, SpellUtil.spellBookItem(spell));
        ctx.workbench.m_6836_(8, new ItemStack((ItemLike)EBItems.MAGIC_CRYSTAL.get(), 10));
        ctx.menu.onApplyButtonPressed(ctx.player);
        ItemStack scroll = ctx.workbench.m_8020_(9);
        Spell resultSpell = SpellUtil.getSpell(scroll);
        GST.assertFalse(helper, "Scroll should not be blank or empty: " + String.valueOf(scroll), scroll.m_41619_() || scroll.m_41720_() instanceof BlankScrollItem);
        GST.assertEquals(helper, "Scroll should contain " + String.valueOf(spell) + " spell.", spell, resultSpell);
        GST.assertTrue(helper, "Crystals should only be partially consumed.", ctx.workbench.m_8020_(8).m_41613_() < 10);
    }

    public static void putSpellOnScrollFilled(GameTestHelper helper) {
        ItemStack scroll = SpellUtil.setSpell(EBItems.SCROLL.get().m_7968_(), Spells.FIREBALL);
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, scroll);
        ctx.workbench.m_6836_(0, SpellUtil.spellBookItem(Spells.ICE_SHARD));
        ctx.workbench.m_6836_(8, new ItemStack((ItemLike)EBItems.MAGIC_CRYSTAL.get(), 10));
        ctx.menu.onApplyButtonPressed(ctx.player);
        scroll = ctx.workbench.m_8020_(9);
        GST.assertFalse(helper, "Scroll should not be blank or empty: " + String.valueOf(scroll), scroll.m_41619_() || scroll.m_41720_() instanceof BlankScrollItem);
        GST.assertFalse(helper, "Crystals shouldn't be consumed.", ctx.workbench.m_8020_(8).m_41619_());
        GST.assertEquals(helper, "Scroll should still contain original spell.", Spells.FIREBALL, SpellUtil.getSpell(scroll));
        helper.m_177412_();
    }

    public static void upgradeNormalArmor(GameTestHelper helper, Item armor, Item upgradeItem) {
        if (!(armor instanceof WizardArmorItem)) {
            helper.m_177284_("Invalid parameters for upgradeNormalArmor test.");
            return;
        }
        WizardArmorItem wizardArmorItem = (WizardArmorItem)armor;
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, armor.m_7968_());
        ctx.workbench.m_6836_(10, upgradeItem.m_7968_());
        ctx.menu.onApplyButtonPressed(ctx.player);
        WizardArmorItem upgradedArmor = (WizardArmorItem)ctx.workbench.m_8020_(9).m_41720_();
        GST.assertTrue(helper, "Armor %s changed equipment slot after upgrade %s".formatted(armor, upgradeItem), upgradedArmor.m_40402_() == wizardArmorItem.m_40402_());
        GST.assertTrue(helper, "Armor %s should be upgraded after applying upgrade item %s.".formatted(armor, upgradeItem), upgradedArmor.getWizardArmorType() != WizardArmorType.WIZARD);
        GST.assertEmpty(helper, "Upgrade item should be consumed.", ctx.workbench.m_8020_(10));
    }

    public static void cannotUpgradeMaxedArmor(GameTestHelper helper, Item armor, Item upgradeItem) {
        if (!(armor instanceof WizardArmorItem)) {
            helper.m_177284_("Invalid parameters for cannotUpgradeMaxedArmor test.");
            return;
        }
        WizardArmorItem wizardArmorItem = (WizardArmorItem)armor;
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, armor.m_7968_());
        ctx.workbench.m_6836_(10, upgradeItem.m_7968_());
        ctx.menu.onApplyButtonPressed(ctx.player);
        WizardArmorItem upgradedArmor = (WizardArmorItem)ctx.workbench.m_8020_(9).m_41720_();
        GST.assertTrue(helper, "Armor %s should not be upgraded further after applying upgrade item %s.".formatted(armor, upgradeItem), upgradedArmor.getWizardArmorType() == wizardArmorItem.getWizardArmorType());
        GST.assertNotEmpty(helper, "Upgrade item should not be consumed.", ctx.workbench.m_8020_(10));
    }

    public static void repairWand(GameTestHelper helper, Item wand, Item crystal) {
        if (!(wand instanceof WandItem) || !(crystal instanceof CrystalItem)) {
            helper.m_177284_("Invalid parameters for repairWand test.");
            return;
        }
        ItemStack wandStack = wand.m_7968_();
        wandStack.m_41721_(120);
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, wandStack);
        ctx.workbench.m_6836_(8, crystal.m_7968_());
        ctx.menu.onApplyButtonPressed(ctx.player);
        wandStack = ctx.workbench.m_8020_(9);
        GST.assertTrue(helper, "Wand %s should be repaired after applying crystal %s.".formatted(wand, crystal), wandStack.m_41773_() < 120);
        GST.assertTrue(helper, "Crystal %s should be consumed after repairing wand %s.".formatted(crystal, wand), ctx.workbench.m_8020_(8).m_41619_());
    }

    public static void cannotExceedBlankScrollLimit(GameTestHelper helper) {
        ItemStack blankScrolls = new ItemStack((ItemLike)EBItems.BLANK_SCROLL.get(), 64);
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, ItemStack.f_41583_);
        ctx.workbench.m_6836_(9, new ItemStack((ItemLike)EBItems.BLANK_SCROLL.get(), 16));
        ctx.player.m_150109_().m_36054_(blankScrolls);
        int playerSlotIndex = -1;
        for (int i = 11; i < ctx.menu.f_38839_.size(); ++i) {
            if (ctx.menu.m_38853_(i).m_7993_().m_41720_() != EBItems.BLANK_SCROLL.get()) continue;
            playerSlotIndex = i;
            break;
        }
        GST.assertTrue(helper, "Player should have blank scrolls in inventory", playerSlotIndex != -1);
        int initialPlayerCount = ctx.menu.m_38853_(playerSlotIndex).m_7993_().m_41613_();
        ItemStack result = ctx.menu.m_7648_(ctx.player, playerSlotIndex);
        int finalCentreCount = ctx.workbench.m_8020_(9).m_41613_();
        int finalPlayerCount = ctx.menu.m_38853_(playerSlotIndex).m_7993_().m_41613_();
        GST.assertTrue(helper, "Centre slot should not exceed 16 blank scrolls", finalCentreCount <= 16);
        GST.assertTrue(helper, "Player inventory should still have blank scrolls if limit reached", finalPlayerCount > 0 || initialPlayerCount <= 16);
        helper.m_177412_();
    }

    public static void cannotExceedSpellBookLimit(GameTestHelper helper, Spell spell) {
        ItemStack wandStack = EBItems.NOVICE_HEALING_WAND.get().m_7968_();
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, wandStack);
        ctx.workbench.m_6836_(0, SpellUtil.spellBookItem(spell));
        ItemStack spellBooks = SpellUtil.spellBookItem(spell);
        spellBooks.m_41764_(64);
        ctx.player.m_150109_().m_36054_(spellBooks);
        int playerSlotIndex = -1;
        for (int i = 11; i < ctx.menu.f_38839_.size(); ++i) {
            ItemStack slotItem = ctx.menu.m_38853_(i).m_7993_();
            if (!(slotItem.m_41720_() instanceof SpellBookItem) || SpellUtil.getSpell(slotItem) != spell) continue;
            playerSlotIndex = i;
            break;
        }
        GST.assertTrue(helper, "Player should have spell books in inventory", playerSlotIndex != -1);
        int initialPlayerCount = ctx.menu.m_38853_(playerSlotIndex).m_7993_().m_41613_();
        ctx.menu.m_7648_(ctx.player, playerSlotIndex);
        int finalSlot0Count = ctx.workbench.m_8020_(0).m_41613_();
        GST.assertTrue(helper, "Spell book slot should not exceed 1 item", finalSlot0Count <= 1);
        int totalSpellBooks = 0;
        for (int i = 0; i < 8; ++i) {
            ItemStack slotItem = ctx.workbench.m_8020_(i);
            if (!(slotItem.m_41720_() instanceof SpellBookItem)) continue;
            totalSpellBooks += slotItem.m_41613_();
            GST.assertTrue(helper, "Each spell book slot should not exceed 1 item", slotItem.m_41613_() <= 1);
        }
        helper.m_177412_();
    }

    public static void cannotExceedUpgradeLimit(GameTestHelper helper, Item upgradeItem) {
        ItemStack wandStack = EBItems.ADVANCED_EARTH_WAND.get().m_7968_();
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, wandStack);
        ctx.workbench.m_6836_(10, new ItemStack((ItemLike)upgradeItem, 1));
        ItemStack upgrades = new ItemStack((ItemLike)upgradeItem, 64);
        ctx.player.m_150109_().m_36054_(upgrades);
        int playerSlotIndex = -1;
        for (int i = 11; i < ctx.menu.f_38839_.size(); ++i) {
            if (ctx.menu.m_38853_(i).m_7993_().m_41720_() != upgradeItem) continue;
            playerSlotIndex = i;
            break;
        }
        GST.assertTrue(helper, "Player should have upgrade items in inventory", playerSlotIndex != -1);
        int initialPlayerCount = ctx.menu.m_38853_(playerSlotIndex).m_7993_().m_41613_();
        ctx.menu.m_7648_(ctx.player, playerSlotIndex);
        int finalUpgradeCount = ctx.workbench.m_8020_(10).m_41613_();
        int finalPlayerCount = ctx.menu.m_38853_(playerSlotIndex).m_7993_().m_41613_();
        GST.assertTrue(helper, "Upgrade slot should not exceed 1 item", finalUpgradeCount <= 1);
        GST.assertTrue(helper, "Player inventory should still have upgrade items if limit reached", finalPlayerCount == initialPlayerCount - (finalUpgradeCount == 1 ? 0 : 1));
        helper.m_177412_();
    }

    private static TestContext setupTest(GameTestHelper helper, ItemStack centerItem) {
        ArcaneWorkbenchBlockEntity workbench = (ArcaneWorkbenchBlockEntity)helper.m_177347_(WORKBENCH_POS);
        GST.assertNotNull(helper, "Arcane Workbench BlockEntity is null", (Object)workbench);
        Player player = GST.mockServerPlayer(helper, PLAYER_POS);
        assert (workbench != null);
        workbench.m_6836_(9, centerItem);
        ArcaneWorkbenchMenu menu = new ArcaneWorkbenchMenu(0, player.m_150109_(), (Container)workbench);
        player.f_36096_ = menu;
        return new TestContext(workbench, player, menu);
    }

    private ArcaneWorkbenchTest() {
    }

    private record TestContext(ArcaneWorkbenchBlockEntity workbench, Player player, ArcaneWorkbenchMenu menu) {
    }
}

