/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.gametest;

import com.binaris.wizardry.api.content.item.ArtefactItem;
import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.core.gametest.GST;
import com.binaris.wizardry.setup.registries.EBItems;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class ArtifactTest {
    private static final Vec3 PLAYER_POS = new Vec3(1.0, 2.0, 1.0);

    public static void condensingRingRecharge(GameTestHelper helper) {
        Player player = GST.mockServerPlayer(helper, PLAYER_POS);
        ItemStack ring = new ItemStack((ItemLike)EBItems.RING_CONDENSING.get());
        ItemStack wand = new ItemStack((ItemLike)EBItems.NOVICE_WAND.get());
        IManaStoringItem manaItem = (IManaStoringItem)wand.m_41720_();
        manaItem.setMana(wand, manaItem.getManaCapacity(wand) - 2);
        player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)wand);
        player.m_150109_().f_35974_.set(player.m_150109_().f_35977_ + 1, (Object)ring);
        player.f_19797_ = 150;
        ((ArtefactItem)ring.m_41720_()).getEffect().onTick((LivingEntity)player, player.m_9236_(), ring);
        int currentMana = ((IManaStoringItem)player.m_150109_().m_36056_().m_41720_()).getMana(player.m_150109_().m_36056_());
        int expectedMana = manaItem.getManaCapacity(wand) - 1;
        GST.assertEquals(helper, "Wand should recharge +1 mana", expectedMana, currentMana);
        helper.m_177412_();
    }

    public static void condensingRingRechargeMultipleItems(GameTestHelper helper) {
        Player player = GST.mockServerPlayer(helper, PLAYER_POS);
        ItemStack ring = new ItemStack((ItemLike)EBItems.RING_CONDENSING.get());
        ItemStack wand1 = new ItemStack((ItemLike)EBItems.NOVICE_WAND.get());
        ItemStack wand2 = new ItemStack((ItemLike)EBItems.APPRENTICE_WAND.get());
        IManaStoringItem manaItem1 = (IManaStoringItem)wand1.m_41720_();
        IManaStoringItem manaItem2 = (IManaStoringItem)wand2.m_41720_();
        manaItem1.setMana(wand1, manaItem1.getManaCapacity(wand1) - 5);
        manaItem2.setMana(wand2, manaItem2.getManaCapacity(wand2) - 5);
        player.m_150109_().f_35974_.set(0, (Object)wand1);
        player.m_150109_().f_35974_.set(1, (Object)wand2);
        player.m_150109_().f_35974_.set(2, (Object)ring);
        player.f_19797_ = 150;
        ((ArtefactItem)ring.m_41720_()).getEffect().onTick((LivingEntity)player, player.m_9236_(), ring);
        GST.assertEquals(helper, "Wand 1 should recharge +1", manaItem1.getManaCapacity(wand1) - 4, manaItem1.getMana(wand1));
        GST.assertEquals(helper, "Wand 2 should recharge +1", manaItem2.getManaCapacity(wand2) - 4, manaItem2.getMana(wand2));
        helper.m_177412_();
    }

    public static void arcaneDefenseAmuletRecharge(GameTestHelper helper) {
        Player player = GST.mockServerPlayer(helper, PLAYER_POS);
        ItemStack amulet = new ItemStack((ItemLike)EBItems.AMULET_ARCANE_DEFENCE.get());
        ItemStack wizardHat = new ItemStack((ItemLike)EBItems.WIZARD_HAT.get());
        IManaStoringItem manaArmor = (IManaStoringItem)wizardHat.m_41720_();
        manaArmor.setMana(wizardHat, manaArmor.getManaCapacity(wizardHat) - 3);
        player.m_8061_(EquipmentSlot.HEAD, wizardHat);
        player.m_150109_().f_35974_.set(0, (Object)amulet);
        player.f_19797_ = 300;
        ((ArtefactItem)amulet.m_41720_()).getEffect().onTick((LivingEntity)player, player.m_9236_(), amulet);
        GST.assertEquals(helper, "Hat should recharge +1", manaArmor.getManaCapacity(wizardHat) - 2, manaArmor.getMana(wizardHat));
        helper.m_177412_();
    }

    public static void arcaneDefenseAmuletRechargesMultipleArmor(GameTestHelper helper) {
        Player player = GST.mockServerPlayer(helper, PLAYER_POS);
        ItemStack amulet = new ItemStack((ItemLike)EBItems.AMULET_ARCANE_DEFENCE.get());
        ItemStack wizardHat = new ItemStack((ItemLike)EBItems.WIZARD_HAT.get());
        ItemStack wizardRobe = new ItemStack((ItemLike)EBItems.WIZARD_ROBE.get());
        ItemStack wizardBoots = new ItemStack((ItemLike)EBItems.WIZARD_BOOTS.get());
        IManaStoringItem manaHat = (IManaStoringItem)wizardHat.m_41720_();
        IManaStoringItem manaRobe = (IManaStoringItem)wizardRobe.m_41720_();
        IManaStoringItem manaBoots = (IManaStoringItem)wizardBoots.m_41720_();
        manaHat.setMana(wizardHat, manaHat.getManaCapacity(wizardHat) - 5);
        manaRobe.setMana(wizardRobe, manaRobe.getManaCapacity(wizardRobe) - 5);
        manaBoots.setMana(wizardBoots, manaBoots.getManaCapacity(wizardBoots) - 5);
        player.m_8061_(EquipmentSlot.HEAD, wizardHat);
        player.m_8061_(EquipmentSlot.CHEST, wizardRobe);
        player.m_8061_(EquipmentSlot.FEET, wizardBoots);
        player.m_150109_().f_35974_.set(0, (Object)amulet);
        player.f_19797_ = 300;
        ((ArtefactItem)amulet.m_41720_()).getEffect().onTick((LivingEntity)player, player.m_9236_(), amulet);
        GST.assertEquals(helper, "Hat must recharge +1", manaHat.getManaCapacity(wizardHat) - 4, manaHat.getMana(wizardHat));
        GST.assertEquals(helper, "Robe must recharge +1", manaRobe.getManaCapacity(wizardRobe) - 4, manaRobe.getMana(wizardRobe));
        GST.assertEquals(helper, "Boots must recharge +1", manaBoots.getManaCapacity(wizardBoots) - 4, manaBoots.getMana(wizardBoots));
        helper.m_177412_();
    }
}

