/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.gametest;

import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.core.gametest.GST;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class EBUtilTest {
    private static final Vec3 BLOCK_POS = new Vec3(1.0, 2.0, 1.0);
    private static final Vec3 ENTITY_POS = new Vec3(2.0, 2.0, 2.0);
    public static final List<Block> POWERFUL_BLOCKS = List.of(Blocks.f_50080_, Blocks.f_50723_, Blocks.f_50721_, Blocks.f_50722_);
    public static final List<Block> NON_POWERFUL_BLOCKS = List.of(Blocks.f_50015_, Blocks.f_50013_, Blocks.f_50043_, Blocks.f_50014_, Blocks.f_50259_, Blocks.f_50011_, Blocks.f_50012_, Blocks.f_220836_, Blocks.f_50493_, Blocks.f_50652_, Blocks.f_152497_);

    @GameTest(template="ebwizardry:empty_3x3x3")
    public static void playerBreakBlockNoPowerful(GameTestHelper helper) {
        Player player = GST.mockServerPlayer(helper, ENTITY_POS);
        for (Block block : NON_POWERFUL_BLOCKS) {
            GST.placeBlock(helper, BLOCK_POS, block);
            boolean canBreak = BlockUtil.canBreak(player, player.m_9236_(), helper.m_177449_(BlockPos.m_274446_((Position)BLOCK_POS)), false);
            GST.assertTrue(helper, "Player should be able to break non-powerful block: " + String.valueOf(block), canBreak);
            player.m_9236_().m_46961_(helper.m_177449_(BlockPos.m_274446_((Position)BLOCK_POS)), false);
        }
        helper.m_177412_();
    }

    @GameTest(template="ebwizardry:empty_3x3x3")
    public static void playerBreakBlockWithPowerful(GameTestHelper helper) {
        Player player = GST.mockServerPlayer(helper, ENTITY_POS);
        for (Block block : POWERFUL_BLOCKS) {
            GST.placeBlock(helper, BLOCK_POS, block);
            boolean canBreak = BlockUtil.canBreak(player, player.m_9236_(), helper.m_177449_(BlockPos.m_274446_((Position)BLOCK_POS)), true);
            GST.assertTrue(helper, "Player should be able to break powerful block with power: " + String.valueOf(block), canBreak);
            player.m_9236_().m_46961_(helper.m_177449_(BlockPos.m_274446_((Position)BLOCK_POS)), false);
        }
        helper.m_177412_();
    }
}

