/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.integrations.accessories;

import com.binaris.wizardry.core.IArtefactEffect;
import com.binaris.wizardry.core.integrations.accessories.AccessoriesArtefactItem;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.Nullable;

class AccessoriesIntegrationImpl {
    AccessoriesIntegrationImpl() {
    }

    static Item createAccessoryItem(Rarity rarity, IArtefactEffect effect) {
        return new AccessoriesArtefactItem(rarity, effect);
    }

    static List<ItemStack> getEquippedItemsFromAccessories(Player player) {
        if (AccessoriesCapability.get((LivingEntity)player) != null) {
            return AccessoriesCapability.get((LivingEntity)player).getAllEquipped().stream().map(SlotEntryReference::stack).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    static boolean isEquippedInAccessories(Player player, Item item) {
        if (AccessoriesCapability.get((LivingEntity)player) != null) {
            return AccessoriesCapability.get((LivingEntity)player).isEquipped(item);
        }
        return false;
    }

    @Nullable
    static ItemStack getEquippedFromAccessories(Player player, Item item) {
        if (AccessoriesCapability.get((LivingEntity)player) != null) {
            return AccessoriesCapability.get((LivingEntity)player).getFirstEquipped(item).stack();
        }
        return null;
    }
}

