/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.integrations.accessories;

import com.binaris.wizardry.api.content.item.ArtefactItem;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.core.IArtefactEffect;
import com.binaris.wizardry.core.integrations.accessories.AccessoriesIntegrationImpl;
import com.binaris.wizardry.core.platform.Services;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.Nullable;

public final class EBAccessoriesIntegration {
    private EBAccessoriesIntegration() {
    }

    public static boolean isAccessoriesLoaded() {
        return Services.PLATFORM.isModLoaded("accessories");
    }

    public static Item getArtifact(Rarity rarity, IArtefactEffect effect) {
        if (!EBAccessoriesIntegration.isAccessoriesLoaded()) {
            return new ArtefactItem(rarity, effect);
        }
        try {
            return AccessoriesIntegrationImpl.createAccessoryItem(rarity, effect);
        }
        catch (NoClassDefFoundError e) {
            return new ArtefactItem(rarity, effect);
        }
    }

    public static List<ItemStack> getEquippedItems(Player player) {
        if (EBAccessoriesIntegration.isAccessoriesLoaded()) {
            try {
                return AccessoriesIntegrationImpl.getEquippedItemsFromAccessories(player);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return InventoryUtil.getHotBarAndOffhand(player).stream().distinct().toList();
    }

    public static boolean isEquipped(Player player, Item item) {
        if (EBAccessoriesIntegration.isAccessoriesLoaded()) {
            try {
                return AccessoriesIntegrationImpl.isEquippedInAccessories(player, item);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return InventoryUtil.getHotBarAndOffhand(player).stream().anyMatch(stack -> stack.m_41720_() == item);
    }

    @Nullable
    public static ItemStack getEquipped(Player player, Item item) {
        if (EBAccessoriesIntegration.isAccessoriesLoaded()) {
            try {
                return AccessoriesIntegrationImpl.getEquippedFromAccessories(player, item);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return InventoryUtil.getHotBarAndOffhand(player).stream().filter(stack -> stack.m_41720_() == item).findFirst().orElse(null);
    }
}

