/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.mixin;

import com.binaris.wizardry.api.content.event.EBLivingDeathEvent;
import com.binaris.wizardry.api.content.event.EBLivingHurtEvent;
import com.binaris.wizardry.api.content.event.EBLivingTick;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    LivingEntity livingEntity = (LivingEntity)this;

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void EBWIZARDRY$tick(CallbackInfo ci) {
        WizardryEventBus.getInstance().fire(new EBLivingTick(this.livingEntity, this.livingEntity.m_9236_()));
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD")}, cancellable=true)
    public void EBWIZARDRY$livingCanBeAffected(MobEffectInstance effect, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = this.livingEntity;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (EBAccessoriesIntegration.isEquipped(player, EBItems.AMULET_ICE_IMMUNITY.get()) && effect.m_19544_() == EBMobEffects.FROST.get()) {
            cir.setReturnValue((Object)false);
        }
        if (EBAccessoriesIntegration.isEquipped(player, EBItems.AMULET_WITHER_IMMUNITY.get()) && effect.m_19544_() == MobEffects.f_19615_) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void EBWIZARDRY$livingEntityHurt(DamageSource source, float f, CallbackInfoReturnable<Boolean> cir) {
        if (WizardryEventBus.getInstance().fire(new EBLivingHurtEvent(this.livingEntity, source, f))) {
            cir.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"jumpFromGround"})
    public void EBWIZARDRY$LivingEntityJump(CallbackInfo ci) {
        if (this.livingEntity.m_21023_(EBMobEffects.FROST.get())) {
            if (this.livingEntity.m_21124_(EBMobEffects.FROST.get()).m_19564_() == 0) {
                this.livingEntity.m_20334_(this.livingEntity.m_20184_().f_82479_, 0.5, this.livingEntity.m_20184_().f_82481_);
            } else {
                this.livingEntity.m_20334_(this.livingEntity.m_20184_().f_82479_, 0.0, this.livingEntity.m_20184_().f_82480_);
            }
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    public void EBWIZARDRY$LivingEntityDie(DamageSource damageSource, CallbackInfo ci) {
        WizardryEventBus.getInstance().fire(new EBLivingDeathEvent(this.livingEntity, damageSource));
    }

    @Inject(method={"shouldDropLoot"}, at={@At(value="RETURN")}, cancellable=true)
    public void EBWIZARDRY$dropLoot(CallbackInfoReturnable<Boolean> cir) {
        Mob mob;
        LivingEntity livingEntity = this.livingEntity;
        if (livingEntity instanceof Mob && Services.OBJECT_DATA.isMinion((Entity)(mob = (Mob)livingEntity))) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"shouldDropExperience"}, at={@At(value="RETURN")}, cancellable=true)
    public void EBWIZARDRY$dropExperience(CallbackInfoReturnable<Boolean> cir) {
        Mob mob;
        LivingEntity livingEntity = this.livingEntity;
        if (livingEntity instanceof Mob && Services.OBJECT_DATA.isMinion((Entity)(mob = (Mob)livingEntity))) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    public boolean EBWIZARDRY$avoidDamageOnFrost(LivingEntity living, DamageSource entity, float ev) {
        if (living.m_21023_(EBMobEffects.FROST.get())) {
            return false;
        }
        return living.m_6469_(entity, ev);
    }
}

