/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.networking;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.client.util.ClientUtils;
import com.binaris.wizardry.api.client.util.GlyphClientHandler;
import com.binaris.wizardry.api.content.entity.living.ISpellCaster;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.spell.NoneSpell;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.client.ParticleSpawner;
import com.binaris.wizardry.content.data.SpellGlyphData;
import com.binaris.wizardry.content.item.ScrollItem;
import com.binaris.wizardry.content.item.WandItem;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.networking.s2c.NPCSpellCastS2C;
import com.binaris.wizardry.core.networking.s2c.ParticleBuilderS2C;
import com.binaris.wizardry.core.networking.s2c.SpellCastS2C;
import com.binaris.wizardry.core.networking.s2c.SpellGlyphPacketS2C;
import com.binaris.wizardry.core.networking.s2c.SpellPropertiesSyncS2C;
import com.binaris.wizardry.core.networking.s2c.TestParticlePacketS2C;
import com.binaris.wizardry.core.platform.Services;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public final class ClientMessageHandler {
    public static void spellCast(SpellCastS2C m) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return;
        }
        Entity e = level.m_6815_(m.getCasterID());
        if (!(e instanceof Player)) {
            return;
        }
        Player caster = (Player)e;
        m.getSpell().cast(new PlayerCastContext((Level)level, caster, m.getHand(), 0, m.getModifiers()));
        SpellCastEvent.Source source = SpellCastEvent.Source.OTHER;
        Item item = caster.m_21120_(m.getHand()).m_41720_();
        if (item instanceof WandItem) {
            source = SpellCastEvent.Source.WAND;
        } else if (item instanceof ScrollItem) {
            source = SpellCastEvent.Source.SCROLL;
        }
        WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(source, m.getSpell(), (LivingEntity)caster, m.getModifiers()));
    }

    public static void npcSpellCast(NPCSpellCastS2C m) {
        LivingEntity livingCaster;
        Entity target;
        Entity caster;
        ClientLevel level;
        block8: {
            block7: {
                Minecraft minecraft = Minecraft.m_91087_();
                level = minecraft.f_91073_;
                if (level == null) {
                    return;
                }
                caster = level.m_6815_(m.getCasterID());
                Entity entity = target = m.getTargetID() == -1 ? null : level.m_6815_(m.getTargetID());
                if (!(caster instanceof LivingEntity)) break block7;
                livingCaster = (LivingEntity)caster;
                if (target instanceof LivingEntity) break block8;
            }
            return;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        m.getSpell().cast(new EntityCastContext((Level)level, livingCaster, m.getHand(), 0, livingTarget, m.getModifiers()));
        WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(SpellCastEvent.Source.NPC, m.getSpell(), livingCaster, m.getModifiers()));
        if (caster instanceof ISpellCaster) {
            ISpellCaster spellCaster = (ISpellCaster)caster;
            if (!m.getSpell().isInstantCast() || m.getSpell() instanceof NoneSpell) {
                spellCaster.setContinuousSpell(m.getSpell());
                spellCaster.setSpellCounter(m.getSpell() instanceof NoneSpell ? 0 : 1);
            } else {
                spellCaster.setSpellCounter(0);
            }
        }
    }

    public static void testParticle(TestParticlePacketS2C m) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        LocalPlayer player = minecraft.f_91074_;
        if (level == null || player == null) {
            return;
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, (double)m.getPos().m_123341_() + 0.5, (double)m.getPos().m_123342_() + 0.5, (double)m.getPos().m_123343_() + 0.5, 0.0, 0.0, 0.0);
        player.m_213846_((Component)Component.m_237113_((String)("Test particle at " + String.valueOf(m.getPos()) + " with color " + m.getColor())));
    }

    public static void spellGlyph(SpellGlyphPacketS2C m) {
        if (GlyphClientHandler.INSTANCE.getGlyphData() == null) {
            GlyphClientHandler.INSTANCE.setGlyphData(new SpellGlyphData());
        }
        ClientUtils.handleGlyphDataPacket(m);
    }

    public static void spellPropertiesSync(SpellPropertiesSyncS2C m) {
        for (Map.Entry<ResourceLocation, SpellProperties> entry : m.getPropertiesMap().entrySet()) {
            Optional<Spell> spell = Optional.ofNullable(Services.REGISTRY_UTIL.getSpell(entry.getKey()));
            if (spell.isEmpty()) {
                EBLogger.warn("Received spell properties for unknown spell: {}", entry.getKey());
                continue;
            }
            spell.get().setProperties(entry.getValue());
        }
    }

    public static void particleBuilder(ParticleBuilderS2C m) {
        ParticleSpawner.spawnClientParticle(m.getData());
    }
}

