/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.networking.c2s;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.content.menu.ArcaneWorkbenchMenu;
import com.binaris.wizardry.core.networking.abst.Message;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ControlInputPacketC2S
implements Message {
    public static final ResourceLocation ID = WizardryMainMod.location("control_input");
    private final ControlType controlType;

    public ControlInputPacketC2S(ControlType type) {
        this.controlType = type;
    }

    public ControlInputPacketC2S(FriendlyByteBuf buf) {
        this.controlType = ControlType.values()[buf.readInt()];
    }

    @Override
    public void encode(FriendlyByteBuf pBuf) {
        pBuf.writeInt(this.controlType.ordinal());
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void handleServer(MinecraftServer server, ServerPlayer player) {
        if (player == null) {
            return;
        }
        ItemStack wand = player.m_21205_();
        if (!(wand.m_41720_() instanceof ISpellCastingItem)) {
            wand = player.m_21206_();
        }
        switch (this.controlType) {
            case NEXT_SPELL_KEY: {
                Item item = wand.m_41720_();
                if (!(item instanceof ISpellCastingItem)) break;
                ISpellCastingItem castItem = (ISpellCastingItem)item;
                castItem.selectNextSpell(wand);
                player.m_5810_();
                break;
            }
            case PREVIOUS_SPELL_KEY: {
                Item item = wand.m_41720_();
                if (!(item instanceof ISpellCastingItem)) break;
                ISpellCastingItem castItem = (ISpellCastingItem)item;
                castItem.selectPreviousSpell(wand);
                player.m_5810_();
                break;
            }
            case APPLY_BUTTON: {
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (!(abstractContainerMenu instanceof ArcaneWorkbenchMenu)) {
                    EBLogger.warn("Received a ControlInputPacketC2S, but the player that sent it was not currently using an arcane workbench. This should not happen!", new Object[0]);
                    break;
                }
                ArcaneWorkbenchMenu menu = (ArcaneWorkbenchMenu)abstractContainerMenu;
                menu.onApplyButtonPressed((Player)player);
                break;
            }
            case CLEAR_BUTTON: {
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (!(abstractContainerMenu instanceof ArcaneWorkbenchMenu)) {
                    EBLogger.warn("Received a ControlInputPacketC2S, but the player that sent it was not currently using an arcane workbench. This should not happen!", new Object[0]);
                    break;
                }
                ArcaneWorkbenchMenu menu = (ArcaneWorkbenchMenu)abstractContainerMenu;
                menu.onClearButtonPressed((Player)player);
            }
        }
    }

    public static enum ControlType {
        APPLY_BUTTON,
        NEXT_SPELL_KEY,
        PREVIOUS_SPELL_KEY,
        RESURRECT_BUTTON,
        CLEAR_BUTTON;

    }
}

