/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.networking.s2c;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.core.networking.ClientMessageHandler;
import com.binaris.wizardry.core.networking.abst.Message;
import com.binaris.wizardry.core.platform.Services;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;

public class NPCSpellCastS2C
implements Message {
    public static final ResourceLocation ID = WizardryMainMod.location("npc_spell_cast");
    int casterID;
    int targetID;
    InteractionHand hand;
    Spell spell;
    SpellModifiers modifiers;

    public NPCSpellCastS2C(int casterID, int targetID, InteractionHand hand, Spell spell, SpellModifiers modifiers) {
        this.casterID = casterID;
        this.targetID = targetID;
        this.hand = hand;
        this.spell = spell;
        this.modifiers = modifiers;
    }

    public NPCSpellCastS2C(FriendlyByteBuf pBuf) {
        this.casterID = pBuf.readInt();
        this.targetID = pBuf.readInt();
        this.hand = pBuf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.spell = Services.REGISTRY_UTIL.getSpell(pBuf.m_130281_());
        this.modifiers = SpellModifiers.fromTag(pBuf.m_130260_());
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void encode(FriendlyByteBuf pBuf) {
        pBuf.writeInt(this.casterID);
        pBuf.writeInt(this.targetID);
        pBuf.writeBoolean(this.hand == InteractionHand.MAIN_HAND);
        pBuf.m_130085_(this.spell.getLocation());
        pBuf.m_130079_(this.modifiers.toTag());
    }

    @Override
    public void handleClient() {
        ClientMessageHandler.npcSpellCast(this);
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public SpellModifiers getModifiers() {
        return this.modifiers;
    }

    public int getCasterID() {
        return this.casterID;
    }

    public int getTargetID() {
        return this.targetID;
    }
}

