/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.networking.s2c;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.core.networking.ClientMessageHandler;
import com.binaris.wizardry.core.networking.abst.Message;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class SpellGlyphPacketS2C
implements Message {
    public static final ResourceLocation ID = WizardryMainMod.location("spell_glyph_packet");
    public HashMap<ResourceLocation, String> names;
    public HashMap<ResourceLocation, String> descriptions;

    public SpellGlyphPacketS2C(HashMap<ResourceLocation, String> names, HashMap<ResourceLocation, String> descriptions) {
        this.names = names != null ? names : new HashMap();
        this.descriptions = descriptions != null ? descriptions : new HashMap();
    }

    public SpellGlyphPacketS2C(FriendlyByteBuf pBuf) {
        this.names = new HashMap();
        this.descriptions = new HashMap();
        int size = pBuf.m_130242_();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = pBuf.m_130281_();
            String name = pBuf.m_130277_();
            String description = pBuf.m_130277_();
            this.names.put(key, name);
            this.descriptions.put(key, description);
        }
    }

    @Override
    public void encode(FriendlyByteBuf pBuf) {
        HashSet<ResourceLocation> keys = new HashSet<ResourceLocation>(this.names.keySet());
        keys.addAll(this.descriptions.keySet());
        pBuf.m_130130_(keys.size());
        for (ResourceLocation key : keys) {
            String desc;
            pBuf.m_130085_(key);
            String name = this.names.get(key);
            if (name == null) {
                name = "";
            }
            if ((desc = this.descriptions.get(key)) == null) {
                desc = "";
            }
            pBuf.m_130070_(name);
            pBuf.m_130070_(desc);
        }
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void handleClient() {
        ClientMessageHandler.spellGlyph(this);
    }

    public HashMap<ResourceLocation, String> getDescriptions() {
        return this.descriptions;
    }

    public HashMap<ResourceLocation, String> getNames() {
        return this.names;
    }
}

