/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.datagen;

import com.binaris.wizardry.datagen.provider.EBAdvancementsProvider;
import com.binaris.wizardry.datagen.provider.EBBlockStateProvider;
import com.binaris.wizardry.datagen.provider.EBBlockTagProvider;
import com.binaris.wizardry.datagen.provider.EBItemModelProvider;
import com.binaris.wizardry.datagen.provider.EBItemTagProvider;
import com.binaris.wizardry.datagen.provider.EBLootTableProvider;
import com.binaris.wizardry.datagen.provider.EBRecipeProvider;
import com.binaris.wizardry.datagen.provider.EBSpellsProvider;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ebwizardry", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EBForgeDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ForgeAdvancementProvider(packOutput, lookupProvider, existingFileHelper, Collections.singletonList(new EBAdvancementsProvider())));
        generator.addProvider(event.includeServer(), (DataProvider)EBLootTableProvider.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new EBBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new EBItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new EBSpellsProvider(packOutput));
        EBBlockTagProvider blockTagProvider = (EBBlockTagProvider)generator.addProvider(event.includeServer(), (DataProvider)new EBBlockTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new EBItemTagProvider(packOutput, lookupProvider, blockTagProvider.m_274426_(), existingFileHelper));
        event.getGenerator().addProvider(event.includeServer(), EBRecipeProvider::new);
    }
}

