/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.datagen.provider;

import com.binaris.wizardry.api.content.DeferredObject;
import com.binaris.wizardry.setup.datagen.EBDataGenProcessor;
import com.binaris.wizardry.setup.registries.EBBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public final class EBBlockStateProvider
extends BlockStateProvider {
    public EBBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "ebwizardry", exFileHelper);
    }

    protected void registerStatesAndModels() {
        EBDataGenProcessor.defaultBlockModels().forEach((name, block) -> this.blockWithItem((DeferredObject<Block>)block));
        this.simpleBlockWithItem(EBBlocks.CRYSTAL_FLOWER.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture(EBBlocks.CRYSTAL_FLOWER.get()).m_135815_(), this.blockTexture(EBBlocks.CRYSTAL_FLOWER.get()))).renderType("cutout"));
        this.simpleBlockWithItem(EBBlocks.POTTED_CRYSTAL_FLOWER.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_crystal_flower", new ResourceLocation("flower_pot_cross"), "plant", this.blockTexture(EBBlocks.CRYSTAL_FLOWER.get()))).renderType("cutout"));
        this.runestone(EBBlocks.FIRE_RUNESTONE.get(), "fire_runestone", "runestone_fire");
        this.runestone(EBBlocks.EARTH_RUNESTONE.get(), "earth_runestone", "runestone_earth");
        this.runestone(EBBlocks.HEALING_RUNESTONE.get(), "healing_runestone", "runestone_healing");
        this.runestone(EBBlocks.ICE_RUNESTONE.get(), "ice_runestone", "runestone_ice");
        this.runestone(EBBlocks.LIGHTNING_RUNESTONE.get(), "lightning_runestone", "runestone_lightning");
        this.runestone(EBBlocks.NECROMANCY_RUNESTONE.get(), "necromancy_runestone", "runestone_necromancy");
        this.runestone(EBBlocks.SORCERY_RUNESTONE.get(), "sorcery_runestone", "runestone_sorcery");
        this.runestonePedestal(EBBlocks.FIRE_RUNESTONE_PEDESTAL.get(), "fire_runestone_pedestal", "runestone_pedestal_fire", "runestone_fire");
        this.runestonePedestal(EBBlocks.EARTH_RUNESTONE_PEDESTAL.get(), "earth_runestone_pedestal", "runestone_pedestal_earth", "runestone_earth");
        this.runestonePedestal(EBBlocks.HEALING_RUNESTONE_PEDESTAL.get(), "healing_runestone_pedestal", "runestone_pedestal_healing", "runestone_healing");
        this.runestonePedestal(EBBlocks.ICE_RUNESTONE_PEDESTAL.get(), "ice_runestone_pedestal", "runestone_pedestal_ice", "runestone_ice");
        this.runestonePedestal(EBBlocks.LIGHTNING_RUNESTONE_PEDESTAL.get(), "lightning_runestone_pedestal", "runestone_pedestal_lightning", "runestone_lightning");
        this.runestonePedestal(EBBlocks.NECROMANCY_RUNESTONE_PEDESTAL.get(), "necromancy_runestone_pedestal", "runestone_pedestal_necromancy", "runestone_necromancy");
        this.runestonePedestal(EBBlocks.SORCERY_RUNESTONE_PEDESTAL.get(), "sorcery_runestone_pedestal", "runestone_pedestal_sorcery", "runestone_sorcery");
        this.bookShelf(EBBlocks.BIRCH_BOOKSHELF.get(), "birch_bookshelf");
        this.bookShelf(EBBlocks.SPRUCE_BOOKSHELF.get(), "spruce_bookshelf");
        this.bookShelf(EBBlocks.JUNGLE_BOOKSHELF.get(), "jungle_bookshelf");
        this.bookShelf(EBBlocks.ACACIA_BOOKSHELF.get(), "acacia_bookshelf");
        this.bookShelf(EBBlocks.DARK_OAK_BOOKSHELF.get(), "dark_oak_bookshelf");
        this.bookShelf(EBBlocks.OAK_BOOKSHELF.get(), "oak_bookshelf");
        this.lectern(EBBlocks.OAK_LECTERN.get(), "oak_lectern");
        this.lectern(EBBlocks.SPRUCE_LECTERN.get(), "spruce_lectern");
        this.lectern(EBBlocks.BIRCH_LECTERN.get(), "birch_lectern");
        this.lectern(EBBlocks.JUNGLE_LECTERN.get(), "jungle_lectern");
        this.lectern(EBBlocks.ACACIA_LECTERN.get(), "acacia_lectern");
        this.lectern(EBBlocks.DARK_OAK_LECTERN.get(), "dark_oak_lectern");
    }

    private void blockWithItem(DeferredObject<Block> block) {
        this.simpleBlockWithItem(block.get(), this.cubeAll(block.get()));
    }

    private void lectern(Block block, String name) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "ebwizardry:block/lectern")).renderType("cutout")).texture("particle", "ebwizardry:block/%s_top".formatted(name))).texture("base", "ebwizardry:block/%s_base".formatted(name))).texture("side", "ebwizardry:block/%s_side".formatted(name))).texture("top", "ebwizardry:block/%s_top".formatted(name))).texture("underside", "ebwizardry:block/%s_underside".formatted(name));
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build());
        ((ItemModelBuilder)this.itemModels().getBuilder(name)).parent((ModelFile)model);
    }

    private void bookShelf(Block block, String name) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "ebwizardry:block/bookshelf")).texture("particle", "ebwizardry:block/%s_side".formatted(name))).texture("side", "ebwizardry:block/%s_side".formatted(name))).texture("inside", "ebwizardry:block/%s_inside".formatted(name))).texture("top", "ebwizardry:block/%s_top".formatted(name));
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)model).rotationY((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_()).build());
        ((ItemModelBuilder)this.itemModels().getBuilder(name)).parent((ModelFile)model);
    }

    private void runestonePedestal(Block block, String name, String textureName, String topBottomTexture) {
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "ebwizardry:block/runestone_pedestal")).texture("side", "ebwizardry:block/%s".formatted(textureName))).texture("top", "ebwizardry:block/%s_0".formatted(topBottomTexture))).texture("bottom", "ebwizardry:block/%s_0".formatted(topBottomTexture));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(name)).parent((ModelFile)this.itemModels().getExistingFile(new ResourceLocation("ebwizardry", "item/runestone_pedestal_item")))).texture("side", "ebwizardry:block/%s".formatted(textureName))).texture("top", "ebwizardry:block/%s_0".formatted(topBottomTexture))).texture("bottom", "ebwizardry:block/%s_0".formatted(topBottomTexture))).texture("overlay", "ebwizardry:block/%s_overlay".formatted(textureName));
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(name))).build());
    }

    private void runestone(Block block, String name, String textureName) {
        for (int i = 1; i <= 4; ++i) {
            String modelName = "%s_%d".formatted(name, i);
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(name)).parent((ModelFile)this.itemModels().getExistingFile(new ResourceLocation("ebwizardry", "item/runestone_item")))).texture("side", "ebwizardry:block/%s_0".formatted(textureName))).texture("rune", "ebwizardry:block/%s_%d".formatted(textureName, i))).texture("overlay", "ebwizardry:block/%s_%d_overlay".formatted(textureName, i));
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, "ebwizardry:block/runestone")).texture("side", "ebwizardry:block/%s_0".formatted(textureName))).texture("rune", "ebwizardry:block/%s_%d".formatted(textureName, i));
            for (int y = 0; y < 360; y += 90) {
                ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(modelName))).uvLock(true);
                if (y != 0) {
                    builder.rotationY(y);
                }
                this.getVariantBuilder(block).partialState().addModels(builder.build());
            }
            for (int x : new int[]{90, 270}) {
                this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(modelName))).uvLock(true).rotationX(x).build());
            }
        }
    }
}

