/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.datagen.provider;

import com.binaris.wizardry.api.content.DeferredObject;
import com.binaris.wizardry.setup.datagen.EBDataGenProcessor;
import com.binaris.wizardry.setup.registries.EBBlocks;
import com.binaris.wizardry.setup.registries.EBItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public final class EBItemModelProvider
extends ItemModelProvider {
    public EBItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "ebwizardry", existingFileHelper);
    }

    protected void registerModels() {
        EBDataGenProcessor.items().forEach((name, item) -> this.simpleItem((String)name));
        this.generateWandPointModel();
        EBDataGenProcessor.wandItems().forEach((name, item) -> this.simpleWand((String)name));
        this.simpleBlockItemBlockTexture(EBBlocks.CRYSTAL_FLOWER);
        this.spawnEgg(EBItems.WIZARD_SPAWN_EGG);
        this.spawnEgg(EBItems.EVIL_WIZARD_SPAWN_EGG);
        this.spawnEgg(EBItems.REMNANT_SPAWN_EGG);
    }

    private void simpleBlockItemBlockTexture(DeferredObject<Block> item) {
        ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)item.get());
        ((ItemModelBuilder)this.withExistingParent(id.m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("ebwizardry", "block/" + id.m_135815_()));
    }

    private void spawnEgg(DeferredObject<Item> item) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item.get());
        this.withExistingParent(id.m_135815_(), this.mcLoc("item/template_spawn_egg"));
    }

    private void simpleItem(String name) {
        ((ItemModelBuilder)this.withExistingParent(name, new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("ebwizardry", "item/" + name));
    }

    private void simpleWand(String name) {
        ItemModelBuilder pointModel = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + "_casting", "item/handheld")).texture("layer0", new ResourceLocation("ebwizardry", "item/" + name));
        pointModel.transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 105.0f).translation(0.0f, 0.0f, -3.25f).scale(0.85f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -105.0f).translation(0.0f, 0.0f, -3.25f).scale(0.85f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 105.0f).translation(1.13f, 3.2f, 0.5f).scale(0.68f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -105.0f).translation(1.13f, 3.2f, 0.5f).scale(0.68f).end();
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation("ebwizardry", "item/" + name))).override().predicate(new ResourceLocation("casting"), 1.0f).model((ModelFile)pointModel).end();
    }

    private void generateWandPointModel() {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("wand_point", "item/handheld");
        builder.transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 105.0f).translation(0.0f, 0.0f, -3.25f).scale(0.85f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -105.0f).translation(0.0f, 0.0f, -3.25f).scale(0.85f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 105.0f).translation(1.13f, 3.2f, 0.5f).scale(0.68f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -105.0f).translation(1.13f, 3.2f, 0.5f).scale(0.68f).end();
    }
}

