/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.datagen.provider;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import org.jetbrains.annotations.NotNull;

public abstract class SpellDataProvider
implements DataProvider {
    protected final PackOutput.PathProvider pathProvider;
    protected final String namespace;

    public SpellDataProvider(PackOutput output, String namespace) {
        this.pathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "spells");
        this.namespace = namespace;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput output) {
        HashSet duplicates = Sets.newHashSet();
        ArrayList futures = new ArrayList();
        this.buildSpells(spell -> {
            if (!duplicates.add(spell.getLocation())) {
                throw new IllegalStateException("Duplicate spell " + String.valueOf(spell.getLocation()));
            }
            if (!spell.property(DefaultProperties.SENSIBLE).booleanValue()) {
                JsonObject jsonObject = spell.getProperties().toJson();
                futures.add(DataProvider.m_253162_((CachedOutput)output, (JsonElement)jsonObject, (Path)this.pathProvider.m_245731_(spell.getLocation())));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String m_6055_() {
        return "Spell Data Provider: " + this.namespace;
    }

    protected abstract void buildSpells(@NotNull Consumer<Spell> var1);
}

