/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.mixin;

import com.binaris.wizardry.client.BlendingHumanoidModel;
import com.binaris.wizardry.content.item.SpectralArmorItem;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SpectralArmorItem.class})
public abstract class SpectralArmorItemMixin
extends ArmorItem {
    @Unique
    private final SpectralArmorItem wizardry$spectralArmorItem = (SpectralArmorItem)((Object)this);

    public SpectralArmorItemMixin(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @Nullable
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                ModelPart innerPart = Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171164_);
                ModelPart outerPart = Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171165_);
                BlendingHumanoidModel innerModel = new BlendingHumanoidModel(innerPart);
                BlendingHumanoidModel outerModel = new BlendingHumanoidModel(outerPart);
                if (SpectralArmorItemMixin.this.wizardry$spectralArmorItem.m_40402_() == EquipmentSlot.LEGS) {
                    return original;
                }
                BlendingHumanoidModel chosen = equipmentSlot == EquipmentSlot.LEGS ? innerModel : outerModel;
                chosen.m_8009_(false);
                switch (equipmentSlot) {
                    case HEAD: {
                        chosen.f_102808_.f_104207_ = true;
                        chosen.f_102809_.f_104207_ = true;
                        break;
                    }
                    case CHEST: {
                        chosen.f_102810_.f_104207_ = true;
                        chosen.f_102811_.f_104207_ = true;
                        chosen.f_102812_.f_104207_ = true;
                        break;
                    }
                    case LEGS: 
                    case FEET: {
                        chosen.f_102813_.f_104207_ = true;
                        chosen.f_102814_.f_104207_ = true;
                    }
                }
                return chosen;
            }
        });
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        String string = "ebwizardry:textures/armor/spectral_armor.png";
        if (slot == EquipmentSlot.LEGS) {
            string = "ebwizardry:textures/armor/spectral_armor_legs.png";
        }
        return string;
    }
}

