/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.mixin;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.client.model.armor.RobeArmorModel;
import com.binaris.wizardry.client.model.armor.WizardArmorModel;
import com.binaris.wizardry.content.item.WizardArmorItem;
import com.binaris.wizardry.content.item.WizardArmorType;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={WizardArmorItem.class})
public abstract class WizardArmorItemMixin
extends ArmorItem {
    @Unique
    WizardArmorItem wizardArmorItem = (WizardArmorItem)((Object)this);
    @Shadow
    private Element element;

    public WizardArmorItemMixin(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                WizardArmorModel wizardArmor = new WizardArmorModel(Minecraft.m_91087_().m_167973_().m_171103_(WizardArmorModel.LAYER_LOCATION));
                RobeArmorModel robeArmor = new RobeArmorModel(Minecraft.m_91087_().m_167973_().m_171103_(RobeArmorModel.LAYER_LOCATION), true);
                if (WizardArmorItemMixin.this.wizardArmorItem.m_40402_() == EquipmentSlot.LEGS) {
                    return original;
                }
                wizardArmor.hat.f_104207_ = equipmentSlot == EquipmentSlot.HEAD;
                wizardArmor.armorBody.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                wizardArmor.robe.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                wizardArmor.left_arm.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                wizardArmor.right_arm.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                wizardArmor.f_102813_.f_104207_ = equipmentSlot == EquipmentSlot.LEGS;
                wizardArmor.f_102814_.f_104207_ = equipmentSlot == EquipmentSlot.LEGS;
                wizardArmor.right_shoe.f_104207_ = equipmentSlot == EquipmentSlot.FEET;
                wizardArmor.left_shoe.f_104207_ = equipmentSlot == EquipmentSlot.FEET;
                robeArmor.armorHead.f_104207_ = equipmentSlot == EquipmentSlot.HEAD;
                robeArmor.armorBody.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                robeArmor.robe.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                robeArmor.left_arm.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                robeArmor.right_arm.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                robeArmor.f_102813_.f_104207_ = equipmentSlot == EquipmentSlot.LEGS;
                robeArmor.f_102814_.f_104207_ = equipmentSlot == EquipmentSlot.LEGS;
                robeArmor.right_shoe.f_104207_ = equipmentSlot == EquipmentSlot.FEET;
                robeArmor.left_shoe.f_104207_ = equipmentSlot == EquipmentSlot.FEET;
                return switch (WizardArmorItemMixin.this.wizardArmorItem.getWizardArmorType()) {
                    case WizardArmorType.WIZARD -> wizardArmor;
                    case WizardArmorType.SAGE -> wizardArmor;
                    case WizardArmorType.BATTLEMAGE -> robeArmor;
                    case WizardArmorType.WARLOCK -> robeArmor;
                    default -> wizardArmor;
                };
            }
        });
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        String s = this.wizardArmorItem.getWizardArmorType().m_6082_() + "_armor";
        if (WizardryMainMod.IS_THE_SEASON && this.wizardArmorItem.getWizardArmorType() == WizardArmorType.WIZARD) {
            s = s + "_festive";
        } else if (this.element != null) {
            s = s + "_" + this.element.getName();
        }
        String string = "ebwizardry:textures/armor/" + s + ".png";
        if (slot == EquipmentSlot.LEGS) {
            string = "ebwizardry:textures/armor/" + s + "_legs.png";
        }
        return string;
    }
}

