/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.network;

import com.binaris.wizardry.capabilities.ArcaneLockDataHolder;
import com.binaris.wizardry.capabilities.CastCommandDataHolder;
import com.binaris.wizardry.capabilities.ContainmentDataHolder;
import com.binaris.wizardry.capabilities.MinionDataHolder;
import com.binaris.wizardry.capabilities.SpellManagerDataHolder;
import com.binaris.wizardry.capabilities.WizardDataHolder;
import com.binaris.wizardry.network.ArcaneLockSyncPacketS2C;
import com.binaris.wizardry.network.ContainmentSyncPacketS2C;
import com.binaris.wizardry.network.MinionSyncPacketS2C;
import com.binaris.wizardry.network.PlayerCapabilitySyncPacketS2C;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class ClientMessageHandlerForge {
    private ClientMessageHandlerForge() {
    }

    public static void arcaneLock(ArcaneLockSyncPacketS2C m) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(m.getPos());
        if (blockEntity == null) {
            return;
        }
        blockEntity.getCapability(ArcaneLockDataHolder.INSTANCE).ifPresent(arcaneLockData -> arcaneLockData.deserializeNBT(m.getData()));
    }

    public static void minionSync(MinionSyncPacketS2C m) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(m.getEntityId());
        if (entity == null) {
            return;
        }
        entity.getCapability(MinionDataHolder.INSTANCE).ifPresent(minionData -> minionData.deserializeNBT(m.getData()));
    }

    public static void containmentSync(ContainmentSyncPacketS2C m) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(m.getEntityId());
        if (entity == null) {
            return;
        }
        entity.getCapability(ContainmentDataHolder.INSTANCE).ifPresent(containmentData -> containmentData.deserializeNBT(m.getData()));
    }

    public static void playerCapabilitySync(PlayerCapabilitySyncPacketS2C m) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        switch (m.getType()) {
            case CAST_COMMAND: {
                player.getCapability(CastCommandDataHolder.INSTANCE).ifPresent(d -> d.deserializeNBT(m.getData()));
                break;
            }
            case SPELL_MANAGER: {
                player.getCapability(SpellManagerDataHolder.INSTANCE).ifPresent(d -> d.deserializeNBT(m.getData()));
                break;
            }
            case WIZARD_DATA: {
                player.getCapability(WizardDataHolder.INSTANCE).ifPresent(d -> d.deserializeNBT(m.getData()));
            }
        }
    }
}

