/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.platform;

import com.binaris.wizardry.api.content.data.ArcaneLockData;
import com.binaris.wizardry.api.content.data.CastCommandData;
import com.binaris.wizardry.api.content.data.ConjureData;
import com.binaris.wizardry.api.content.data.ContainmentData;
import com.binaris.wizardry.api.content.data.IStoredSpellVar;
import com.binaris.wizardry.api.content.data.ImbuementEnchantData;
import com.binaris.wizardry.api.content.data.MinionData;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.data.WizardData;
import com.binaris.wizardry.capabilities.ArcaneLockDataHolder;
import com.binaris.wizardry.capabilities.CastCommandDataHolder;
import com.binaris.wizardry.capabilities.ConjureDataHolder;
import com.binaris.wizardry.capabilities.ContainmentDataHolder;
import com.binaris.wizardry.capabilities.ImbuementEnchantDataHolder;
import com.binaris.wizardry.capabilities.MinionDataHolder;
import com.binaris.wizardry.capabilities.SpellManagerDataHolder;
import com.binaris.wizardry.capabilities.WizardDataHolder;
import com.binaris.wizardry.core.platform.services.IObjectData;
import java.util.Arrays;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ForgeObjectData
implements IObjectData {
    @Override
    public ConjureData getConjureData(ItemStack stack) {
        return (ConjureData)stack.getCapability(ConjureDataHolder.INSTANCE).orElse(null);
    }

    @Override
    public ImbuementEnchantData getImbuementData(ItemStack stack) {
        return (ImbuementEnchantData)stack.getCapability(ImbuementEnchantDataHolder.INSTANCE).orElse(null);
    }

    @Override
    public CastCommandData getCastCommandData(Player player) {
        return (CastCommandData)player.getCapability(CastCommandDataHolder.INSTANCE).orElseThrow(() -> new IllegalStateException("CastCommandData capability not present on player " + String.valueOf(player)));
    }

    @Override
    public SpellManagerData getSpellManagerData(Player player) {
        return (SpellManagerData)player.getCapability(SpellManagerDataHolder.INSTANCE).orElseThrow(() -> new IllegalStateException("SpellManagerData capability not present on player " + String.valueOf(player)));
    }

    @Override
    public void spellStoredVariables(IStoredSpellVar<?> ... variables) {
        SpellManagerDataHolder.storedVariables.addAll(Arrays.asList(variables));
    }

    @Override
    public WizardData getWizardData(Player player) {
        return (WizardData)player.getCapability(WizardDataHolder.INSTANCE).orElseThrow(() -> new IllegalStateException("WizardData capability not present on player " + String.valueOf(player)));
    }

    @Override
    public MinionData getMinionData(Mob mob) {
        return (MinionData)mob.getCapability(MinionDataHolder.INSTANCE).orElseThrow(() -> new IllegalStateException("MinionData capability not present on mob " + String.valueOf(mob)));
    }

    @Override
    public ContainmentData getContainmentData(LivingEntity entity) {
        return (ContainmentData)entity.getCapability(ContainmentDataHolder.INSTANCE).orElseThrow(() -> new IllegalStateException("ContainmentData capability not present on entity " + String.valueOf(entity)));
    }

    @Override
    public boolean isMinion(Entity mob) {
        if (!(mob instanceof Mob)) {
            return false;
        }
        if (!mob.getCapability(MinionDataHolder.INSTANCE).isPresent()) {
            return false;
        }
        MinionDataHolder minionData = (MinionDataHolder)mob.getCapability(MinionDataHolder.INSTANCE).orElseThrow(() -> new IllegalStateException("MinionData capability not present on mob " + String.valueOf(mob)));
        return minionData.isSummoned();
    }

    @Override
    public ArcaneLockData getArcaneLockData(BlockEntity blockEntity) {
        return (ArcaneLockData)blockEntity.getCapability(ArcaneLockDataHolder.INSTANCE).orElse(null);
    }
}

