/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.platform;

import com.binaris.wizardry.core.platform.services.IPlatformHelper;
import com.binaris.wizardry.registry.EBArgumentTypesForge;
import com.mojang.brigadier.arguments.ArgumentType;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLLoader.getDist().isDedicatedServer();
    }

    @Override
    public boolean intHotBiomes(Holder<Biome> biome) {
        return biome.m_203656_(Tags.Biomes.IS_HOT) || biome.m_203656_(Tags.Biomes.IS_DRY);
    }

    @Override
    public boolean inEarthBiomes(Holder<Biome> biome) {
        return biome.m_203565_(Biomes.f_48222_) || biome.m_203565_(Biomes.f_48205_) || biome.m_203656_(Tags.Biomes.IS_CONIFEROUS);
    }

    @Override
    public boolean inIceBiomes(Holder<Biome> biome) {
        return biome.m_203656_(Tags.Biomes.IS_SNOWY);
    }

    @Override
    public <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void registerArgumentType(ResourceLocation id, Class<? extends A> clazz, ArgumentTypeInfo<A, T> serializer) {
        EBArgumentTypesForge.registerArgumentType(id.m_135815_(), clazz, serializer);
    }

    @Override
    public boolean firePlayerBlockBreakEvent(Level level, BlockPos pos, Player player) {
        BlockState state = level.m_8055_(pos);
        BlockEvent.BreakEvent testEvent = new BlockEvent.BreakEvent(level, pos, state, player);
        MinecraftForge.EVENT_BUS.post((Event)testEvent);
        return testEvent.isCanceled();
    }

    @Override
    public boolean fireMobBlockBreakEvent(Level level, BlockPos pos, Mob mob) {
        return !ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)mob);
    }
}

