/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.platform;

import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.core.platform.services.IRegistryUtil;
import com.binaris.wizardry.registry.EBRegistriesForge;
import java.util.Collection;
import java.util.Comparator;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ForgeRegistryUtil
implements IRegistryUtil {
    @Override
    public Collection<Element> getElements() {
        return EBRegistriesForge.ELEMENT.get().getValues().stream().toList();
    }

    @Override
    public Collection<SpellTier> getTiers() {
        return EBRegistriesForge.TIER.get().getValues().stream().sorted(Comparator.comparingInt(t -> t.level)).toList();
    }

    @Override
    public Collection<Spell> getSpells() {
        return EBRegistriesForge.SPELL.get().getValues().stream().toList();
    }

    @Override
    @Nullable
    public Element getElement(ResourceLocation location) {
        return (Element)EBRegistriesForge.ELEMENT.get().getValue(location);
    }

    @Override
    @Nullable
    public SpellTier getTier(ResourceLocation location) {
        return (SpellTier)EBRegistriesForge.TIER.get().getValue(location);
    }

    @Override
    @Nullable
    public Spell getSpell(ResourceLocation location) {
        return (Spell)EBRegistriesForge.SPELL.get().getValue(location);
    }

    @Override
    @Nullable
    public ResourceLocation getSpell(Spell spell) {
        return EBRegistriesForge.SPELL.get().getKey((Object)spell);
    }

    @Override
    @Nullable
    public ResourceLocation getElement(Element element) {
        return EBRegistriesForge.ELEMENT.get().getKey((Object)element);
    }

    @Override
    @Nullable
    public ResourceLocation getTier(SpellTier tier) {
        return EBRegistriesForge.TIER.get().getKey((Object)tier);
    }
}

