/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.datagen;

import com.binaris.wizardry.api.content.DeferredObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class EBDataGenProcessor {
    private static final Map<String, DeferredObject<? extends Item>> DEFAULT_ITEMS = new HashMap<String, DeferredObject<? extends Item>>();
    private static final Map<String, DeferredObject<? extends Item>> WAND_ITEMS = new HashMap<String, DeferredObject<? extends Item>>();
    private static final Map<String, DeferredObject<Block>> DEFAULT_BLOCK_MODELS = new HashMap<String, DeferredObject<Block>>();
    private static final Map<String, DeferredObject<Block>> DEFAULT_BLOCK_DROP = new HashMap<String, DeferredObject<Block>>();

    private EBDataGenProcessor() {
    }

    public static void addDefaultItem(String name, DeferredObject<? extends Item> item) {
        DEFAULT_ITEMS.put(name, item);
    }

    public static void addWandItem(String name, DeferredObject<? extends Item> item) {
        WAND_ITEMS.put(name, item);
    }

    public static void addDefaultBlockModel(String name, DeferredObject<Block> blockModel) {
        DEFAULT_BLOCK_MODELS.put(name, blockModel);
    }

    public static void addDefaultBlockDrop(String name, DeferredObject<Block> blockDrop) {
        DEFAULT_BLOCK_DROP.put(name, blockDrop);
    }

    public static Map<String, DeferredObject<? extends Item>> items() {
        return DEFAULT_ITEMS;
    }

    public static Map<String, DeferredObject<? extends Item>> wandItems() {
        return WAND_ITEMS;
    }

    public static Map<String, DeferredObject<Block>> defaultBlockModels() {
        return DEFAULT_BLOCK_MODELS;
    }

    public static Map<String, DeferredObject<Block>> defaultBlockDrops() {
        return DEFAULT_BLOCK_DROP;
    }
}

