/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.registries;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.DeferredObject;
import com.binaris.wizardry.api.content.util.RegisterFunction;
import com.binaris.wizardry.content.block.ArcaneWorkbenchBlock;
import com.binaris.wizardry.content.block.BookShelfBlock;
import com.binaris.wizardry.content.block.CrystalFlowerBlock;
import com.binaris.wizardry.content.block.ImbuementAltarBlock;
import com.binaris.wizardry.content.block.MagicLecternBlock;
import com.binaris.wizardry.content.block.PermafrostBlock;
import com.binaris.wizardry.content.block.ReceptacleBlock;
import com.binaris.wizardry.content.block.RunestonePedestalBlock;
import com.binaris.wizardry.content.block.VanishingCobwebBlock;
import com.binaris.wizardry.content.block.WallReceptacleBlock;
import com.binaris.wizardry.setup.datagen.EBDataGenProcessor;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public final class EBBlocks {
    public static final Map<String, DeferredObject<Block>> BLOCKS = new LinkedHashMap<String, DeferredObject<Block>>();
    public static final Map<String, DeferredObject<Block>> BLOCK_ITEMS = new LinkedHashMap<String, DeferredObject<Block>>();
    public static final DeferredObject<Block> MAGIC_CRYSTAL_BLOCK = EBBlocks.crystalBlock("magic", MapColor.f_283765_);
    public static final DeferredObject<Block> FIRE_CRYSTAL_BLOCK = EBBlocks.crystalBlock("fire", MapColor.f_283895_);
    public static final DeferredObject<Block> ICE_CRYSTAL_BLOCK = EBBlocks.crystalBlock("ice", MapColor.f_283869_);
    public static final DeferredObject<Block> LIGHTNING_CRYSTAL_BLOCK = EBBlocks.crystalBlock("lightning", MapColor.f_283772_);
    public static final DeferredObject<Block> NECROMANCY_CRYSTAL_BLOCK = EBBlocks.crystalBlock("necromancy", MapColor.f_283889_);
    public static final DeferredObject<Block> EARTH_CRYSTAL_BLOCK = EBBlocks.crystalBlock("earth", MapColor.f_283784_);
    public static final DeferredObject<Block> SORCERY_CRYSTAL_BLOCK = EBBlocks.crystalBlock("sorcery", MapColor.f_283916_);
    public static final DeferredObject<Block> HEALING_CRYSTAL_BLOCK = EBBlocks.crystalBlock("healing", MapColor.f_283832_);
    public static final DeferredObject<Block> CRYSTAL_ORE = EBBlocks.block("crystal_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60913_(2.0f, 5.0f).m_60918_(SoundType.f_56742_), (IntProvider)UniformInt.m_146622_((int)4, (int)8)), true, false, true);
    public static final DeferredObject<Block> DEEPSLATE_CRYSTAL_ORE = EBBlocks.block("deepslate_crystal_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60913_(2.0f, 5.0f).m_60918_(SoundType.f_56742_), (IntProvider)UniformInt.m_146622_((int)4, (int)8)), true, true, true);
    public static final DeferredObject<Block> CRYSTAL_FLOWER = EBBlocks.block("crystal_flower", () -> new CrystalFlowerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50355_).m_60910_().m_60953_(state -> 15)), false, false, true);
    public static final DeferredObject<Block> POTTED_CRYSTAL_FLOWER = EBBlocks.block("potted_crystal_flower", () -> new FlowerPotBlock(CRYSTAL_FLOWER.get(), BlockBehaviour.Properties.m_284310_().m_60966_().m_60955_().m_60953_(state -> 15).m_278166_(PushReaction.DESTROY)), false, false, false);
    public static final DeferredObject<Block> PERMAFROST = EBBlocks.block("permafrost", PermafrostBlock::new, false, false, false);
    public static final DeferredObject<Block> VANISHING_COBWEB = EBBlocks.block("vanishing_cobweb", () -> new VanishingCobwebBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50033_)), false, false, false);
    public static final DeferredObject<Block> ARCANE_WORKBENCH = EBBlocks.block("arcane_workbench", () -> new ArcaneWorkbenchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)), false, true, true);
    public static final DeferredObject<Block> GILDED_OAK_WOOD = EBBlocks.block("gilded_oak_wood", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)), true, true, true);
    public static final DeferredObject<Block> GILDED_SPRUCE_WOOD = EBBlocks.block("gilded_spruce_wood", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)), true, true, true);
    public static final DeferredObject<Block> GILDED_BIRCH_WOOD = EBBlocks.block("gilded_birch_wood", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)), true, true, true);
    public static final DeferredObject<Block> GILDED_JUNGLE_WOOD = EBBlocks.block("gilded_jungle_wood", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)), true, true, true);
    public static final DeferredObject<Block> GILDED_ACACIA_WOOD = EBBlocks.block("gilded_acacia_wood", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)), true, true, true);
    public static final DeferredObject<Block> GILDED_DARK_OAK_WOOD = EBBlocks.block("gilded_dark_oak_wood", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)), true, true, true);
    public static final DeferredObject<Block> OAK_BOOKSHELF = EBBlocks.block("oak_bookshelf", BookShelfBlock::new, false, true, true);
    public static final DeferredObject<Block> SPRUCE_BOOKSHELF = EBBlocks.block("spruce_bookshelf", BookShelfBlock::new, false, true, true);
    public static final DeferredObject<Block> BIRCH_BOOKSHELF = EBBlocks.block("birch_bookshelf", BookShelfBlock::new, false, true, true);
    public static final DeferredObject<Block> JUNGLE_BOOKSHELF = EBBlocks.block("jungle_bookshelf", BookShelfBlock::new, false, true, true);
    public static final DeferredObject<Block> ACACIA_BOOKSHELF = EBBlocks.block("acacia_bookshelf", BookShelfBlock::new, false, true, true);
    public static final DeferredObject<Block> DARK_OAK_BOOKSHELF = EBBlocks.block("dark_oak_bookshelf", BookShelfBlock::new, false, true, true);
    public static final DeferredObject<Block> OAK_LECTERN = EBBlocks.block("oak_lectern", MagicLecternBlock::new, false, true, true);
    public static final DeferredObject<Block> SPRUCE_LECTERN = EBBlocks.block("spruce_lectern", MagicLecternBlock::new, false, true, true);
    public static final DeferredObject<Block> BIRCH_LECTERN = EBBlocks.block("birch_lectern", MagicLecternBlock::new, false, true, true);
    public static final DeferredObject<Block> JUNGLE_LECTERN = EBBlocks.block("jungle_lectern", MagicLecternBlock::new, false, true, true);
    public static final DeferredObject<Block> ACACIA_LECTERN = EBBlocks.block("acacia_lectern", MagicLecternBlock::new, false, true, true);
    public static final DeferredObject<Block> DARK_OAK_LECTERN = EBBlocks.block("dark_oak_lectern", MagicLecternBlock::new, false, true, true);
    public static final DeferredObject<Block> FIRE_RUNESTONE = EBBlocks.block("fire_runestone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f)), false, true, true);
    public static final DeferredObject<Block> ICE_RUNESTONE = EBBlocks.block("ice_runestone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f)), false, true, true);
    public static final DeferredObject<Block> LIGHTNING_RUNESTONE = EBBlocks.block("lightning_runestone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f)), false, true, true);
    public static final DeferredObject<Block> NECROMANCY_RUNESTONE = EBBlocks.block("necromancy_runestone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f)), false, true, true);
    public static final DeferredObject<Block> EARTH_RUNESTONE = EBBlocks.block("earth_runestone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f)), false, true, true);
    public static final DeferredObject<Block> SORCERY_RUNESTONE = EBBlocks.block("sorcery_runestone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f)), false, true, true);
    public static final DeferredObject<Block> HEALING_RUNESTONE = EBBlocks.block("healing_runestone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f)), false, true, true);
    public static final DeferredObject<Block> FIRE_RUNESTONE_PEDESTAL = EBBlocks.block("fire_runestone_pedestal", () -> new RunestonePedestalBlock(Elements.FIRE), false, true, true);
    public static final DeferredObject<Block> ICE_RUNESTONE_PEDESTAL = EBBlocks.block("ice_runestone_pedestal", () -> new RunestonePedestalBlock(Elements.ICE), false, true, true);
    public static final DeferredObject<Block> LIGHTNING_RUNESTONE_PEDESTAL = EBBlocks.block("lightning_runestone_pedestal", () -> new RunestonePedestalBlock(Elements.LIGHTNING), false, true, true);
    public static final DeferredObject<Block> NECROMANCY_RUNESTONE_PEDESTAL = EBBlocks.block("necromancy_runestone_pedestal", () -> new RunestonePedestalBlock(Elements.NECROMANCY), false, true, true);
    public static final DeferredObject<Block> EARTH_RUNESTONE_PEDESTAL = EBBlocks.block("earth_runestone_pedestal", () -> new RunestonePedestalBlock(Elements.EARTH), false, true, true);
    public static final DeferredObject<Block> SORCERY_RUNESTONE_PEDESTAL = EBBlocks.block("sorcery_runestone_pedestal", () -> new RunestonePedestalBlock(Elements.SORCERY), false, true, true);
    public static final DeferredObject<Block> HEALING_RUNESTONE_PEDESTAL = EBBlocks.block("healing_runestone_pedestal", () -> new RunestonePedestalBlock(Elements.HEALING), false, true, true);
    public static final DeferredObject<Block> RECEPTACLE = EBBlocks.block("receptacle", ReceptacleBlock::new, false, false, false);
    public static final DeferredObject<Block> WALL_RECEPTACLE = EBBlocks.block("wall_receptacle", WallReceptacleBlock::new, false, false, false);
    public static final DeferredObject<Block> IMBUEMENT_ALTAR = EBBlocks.block("imbuement_altar", ImbuementAltarBlock::new, false, true, true);

    private EBBlocks() {
    }

    public static void register(RegisterFunction<Block> function) {
        BLOCKS.forEach((name, block) -> function.register((Registry<Block>)BuiltInRegistries.f_256975_, WizardryMainMod.location(name), (Block)block.get()));
    }

    static DeferredObject<Block> crystalBlock(String elementName, MapColor color) {
        return EBBlocks.block("crystal_block_" + elementName, () -> new DropExperienceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_154654_).m_60999_(), (IntProvider)UniformInt.m_146622_((int)0, (int)2)));
    }

    static DeferredObject<Block> block(String name) {
        return EBBlocks.block(name, () -> new Block(BlockBehaviour.Properties.m_284310_()));
    }

    static DeferredObject<Block> block(String name, Supplier<Block> blockSupplier) {
        return EBBlocks.block(name, blockSupplier, true, true, true);
    }

    static DeferredObject<Block> block(String name, boolean defaultModel, boolean defaultDrop, boolean item) {
        return EBBlocks.block(name, () -> new Block(BlockBehaviour.Properties.m_284310_()), defaultModel, defaultDrop, item);
    }

    static DeferredObject<Block> block(String name, Supplier<Block> blockSupplier, boolean defaultModel, boolean defaultDrop, boolean item) {
        return EBBlocks.block(name, blockSupplier, item ? registeredBlock -> EBItems.item(name, () -> new BlockItem((Block)registeredBlock.get(), new Item.Properties()), false, false) : null, defaultModel, defaultDrop);
    }

    static DeferredObject<Block> block(String name, Supplier<Block> blockSupplier, @Nullable Consumer<DeferredObject<Block>> registerBlockItem, boolean defaultModel, boolean defaultDrop) {
        DeferredObject<Block> ret = new DeferredObject<Block>(blockSupplier);
        BLOCKS.put(name, ret);
        if (registerBlockItem != null) {
            registerBlockItem.accept(ret);
            BLOCK_ITEMS.put(name, ret);
        }
        if (defaultModel) {
            EBDataGenProcessor.addDefaultBlockModel(name, ret);
        }
        if (defaultDrop) {
            EBDataGenProcessor.addDefaultBlockDrop(name, ret);
        }
        return ret;
    }
}

