/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.registries;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.util.RegisterFunction;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.client.NotImplementedItems;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBBlocks;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public final class EBCreativeTabs {
    static Map<String, Supplier<CreativeModeTab>> CREATIVE_MODE_TABS = new LinkedHashMap<String, Supplier<CreativeModeTab>>();
    public static final Supplier<CreativeModeTab> ITEMS = EBCreativeTabs.creativeTab("ebwizardry", () -> CreativeModeTab.m_257815_((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).m_257737_(() -> new ItemStack((ItemLike)EBItems.MAGIC_CRYSTAL.get())).m_257941_((Component)Component.m_237115_((String)"creativetab.ebwizardry")).m_257501_((parameters, output) -> EBItems.GENERAL_ITEMS.forEach(item -> {
        if (item.equals(EBItems.ARCANE_TOME)) {
            EBCreativeTabs.createTomes().forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
        } else {
            output.m_246326_((ItemLike)item.get());
        }
    })).m_257652_());
    public static final Supplier<CreativeModeTab> WANDS = EBCreativeTabs.creativeTab("ebwizardry_wands", () -> CreativeModeTab.m_257815_((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).m_257737_(() -> new ItemStack((ItemLike)EBItems.ADVANCED_WAND.get())).m_257941_((Component)Component.m_237115_((String)"creativetab.ebwizardry_wands")).m_257501_((parameters, output) -> EBItems.WANDS.forEach(i -> output.m_246326_((ItemLike)i.get()))).m_257652_());
    public static final Supplier<CreativeModeTab> ARMORS = EBCreativeTabs.creativeTab("ebwizardry_armors", () -> CreativeModeTab.m_257815_((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).m_257737_(() -> new ItemStack((ItemLike)EBItems.WIZARD_HAT.get())).m_257941_((Component)Component.m_237115_((String)"creativetab.ebwizardry_armors")).m_257501_((parameters, output) -> EBItems.ARMORS.forEach(i -> output.m_246326_((ItemLike)i.get()))).m_257652_());
    public static final Supplier<CreativeModeTab> ARTIFACTS = EBCreativeTabs.creativeTab("ebwizardry_artifacts", () -> CreativeModeTab.m_257815_((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).m_257737_(() -> new ItemStack((ItemLike)EBItems.AMULET_RESURRECTION.get())).m_257941_((Component)Component.m_237115_((String)"creativetab.ebwizardry_artifacts")).m_257501_((parameters, output) -> EBItems.ARTIFACTS.forEach(i -> {
        if (!NotImplementedItems.notImplemented((Item)i.get())) {
            output.m_246326_((ItemLike)i.get());
        }
    })).m_257652_());
    public static final Supplier<CreativeModeTab> SPELLS = EBCreativeTabs.creativeTab("ebwizardry_spells", () -> CreativeModeTab.m_257815_((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).m_257737_(() -> new ItemStack((ItemLike)EBItems.SPELL_BOOK.get())).m_257941_((Component)Component.m_237115_((String)"creativetab.ebwizardry_spells")).m_257501_((parameters, output) -> {
        EBCreativeTabs.createSpellBooks().forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
        EBCreativeTabs.createScrolls().forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
    }).m_257652_());
    public static final Supplier<CreativeModeTab> BLOCKS = EBCreativeTabs.creativeTab("ebwizardry_blocks", () -> CreativeModeTab.m_257815_((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).m_257737_(() -> new ItemStack((ItemLike)EBBlocks.EARTH_CRYSTAL_BLOCK.get().m_5456_())).m_257941_((Component)Component.m_237115_((String)"creativetab.ebwizardry_blocks")).m_257501_((parameters, output) -> {
        EBBlocks.BLOCK_ITEMS.forEach((name, block) -> output.m_246326_((ItemLike)((Block)block.get()).m_5456_()));
        output.m_246326_((ItemLike)EBItems.RECEPTACLE.get());
    }).m_257652_());

    private EBCreativeTabs() {
    }

    public static void register(RegisterFunction<CreativeModeTab> function) {
        CREATIVE_MODE_TABS.forEach((id, creativeModeTabSupplier) -> function.register(BuiltInRegistries.f_279662_, WizardryMainMod.location(id), (CreativeModeTab)creativeModeTabSupplier.get()));
    }

    private static List<ItemStack> createSpellBooks() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Services.REGISTRY_UTIL.getSpells().stream().filter(spell -> spell != Spells.NONE).forEach(spell -> list.add(SpellUtil.setSpell(new ItemStack((ItemLike)EBItems.SPELL_BOOK.get()), spell)));
        return list;
    }

    private static List<ItemStack> createScrolls() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Services.REGISTRY_UTIL.getSpells().stream().filter(spell -> spell != Spells.NONE).forEach(spell -> list.add(SpellUtil.setSpell(new ItemStack((ItemLike)EBItems.SCROLL.get()), spell)));
        return list;
    }

    private static List<ItemStack> createTomes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Services.REGISTRY_UTIL.getTiers().stream().filter(tier -> tier != SpellTiers.NOVICE).forEach(spellTier -> list.add(SpellUtil.arcaneTomeItem(spellTier)));
        return list;
    }

    static Supplier<CreativeModeTab> creativeTab(String name, Supplier<CreativeModeTab> creativeModeTab) {
        CREATIVE_MODE_TABS.put(name, creativeModeTab);
        return creativeModeTab;
    }
}

