/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.registries;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.util.RegisterFunction;
import com.binaris.wizardry.content.loot.RandomSpellFunction;
import com.binaris.wizardry.content.loot.WizardSpellFunction;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;

public final class EBLootFunctions {
    private static final Map<ResourceLocation, LootItemFunctionType> FUNCTIONS_TO_REGISTER = new LinkedHashMap<ResourceLocation, LootItemFunctionType>();
    public static final LootItemFunctionType RANDOM_SPELL = EBLootFunctions.register("random_spell", new LootItemFunctionType((Serializer)new RandomSpellFunction.Serializer()));
    public static final LootItemFunctionType WIZARD_SPELL = EBLootFunctions.register("wizard_spell", new LootItemFunctionType((Serializer)new WizardSpellFunction.Serializer()));

    private EBLootFunctions() {
    }

    private static LootItemFunctionType register(String name, LootItemFunctionType type) {
        FUNCTIONS_TO_REGISTER.put(WizardryMainMod.location(name), type);
        return type;
    }

    public static void register(RegisterFunction<LootItemFunctionType> function) {
        FUNCTIONS_TO_REGISTER.forEach((id, loot_function) -> function.register((Registry<LootItemFunctionType>)BuiltInRegistries.f_256753_, (ResourceLocation)id, (LootItemFunctionType)loot_function));
    }
}

