/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.registries;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.core.EBConfig;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public final class EBLootTables {
    private static final Set<ResourceLocation> LOOT_TABLES = Sets.newHashSet();
    public static final ResourceLocation DUNGEON_ADDITIONS = EBLootTables.register("chests/dungeon_additions");
    public static final ResourceLocation DISPENSER_ADDITIONS = EBLootTables.register("chests/jungle_dispenser_additions");
    public static final ResourceLocation JUNK_FISHING_ADDITIONS = EBLootTables.register("gameplay/fishing/junk_additions");
    public static final ResourceLocation TREASURE_FISHING_ADDITIONS = EBLootTables.register("gameplay/fishing/treasure_additions");
    public static final ResourceLocation SUBSET_ARCANE_TOMES = EBLootTables.register("subsets/arcane_tomes");
    public static final ResourceLocation SUBSET_ARMOR_UPGRADES = EBLootTables.register("subsets/armor_upgrades");
    public static final ResourceLocation SUBSET_ELEMENTAL_CRYSTALS = EBLootTables.register("subsets/elemental_crystals");
    public static final ResourceLocation SUBSET_EPIC_ARTEFACTS = EBLootTables.register("subsets/epic_artefacts");
    public static final ResourceLocation SUBSET_RARE_ARTEFACTS = EBLootTables.register("subsets/rare_artefacts");
    public static final ResourceLocation SUBSET_UNCOMMON_ARTEFACTS = EBLootTables.register("subsets/uncommon_artefacts");
    public static final ResourceLocation SUBSET_WIZARD_ARMOR = EBLootTables.register("subsets/wizard_armor");
    public static final ResourceLocation SUBSET_WAND_UPGRADES = EBLootTables.register("subsets/wand_upgrades");
    public static final ResourceLocation SHRINE = EBLootTables.register("chests/shrine");
    private static final List<Pair<ResourceLocation, LootPool>> LOOT_INJECTIONS = new ArrayList<Pair<ResourceLocation, LootPool>>();

    private EBLootTables() {
    }

    private static ResourceLocation register(String location) {
        return EBLootTables.register(WizardryMainMod.location(location));
    }

    private static ResourceLocation register(ResourceLocation location) {
        if (LOOT_TABLES.add(location)) {
            return location;
        }
        throw new IllegalArgumentException(String.valueOf(location) + " is already a registered built-in loot table");
    }

    public static void initInjections() {
        Arrays.stream(EBConfig.lootInjectionLocations).forEach(location -> LOOT_INJECTIONS.add((Pair<ResourceLocation, LootPool>)Pair.of((Object)location, (Object)EBLootTables.createAdditivePool(DUNGEON_ADDITIONS, 1))));
        LOOT_INJECTIONS.add((Pair<ResourceLocation, LootPool>)Pair.of((Object)new ResourceLocation("chests/gameplay/fishing/junk"), (Object)EBLootTables.createAdditivePool(JUNK_FISHING_ADDITIONS, 4)));
        LOOT_INJECTIONS.add((Pair<ResourceLocation, LootPool>)Pair.of((Object)new ResourceLocation("chests/gameplay/fishing/treasure"), (Object)EBLootTables.createAdditivePool(TREASURE_FISHING_ADDITIONS, 4)));
        LOOT_INJECTIONS.add((Pair<ResourceLocation, LootPool>)Pair.of((Object)new ResourceLocation("chests/jungle_temple_dispenser"), (Object)EBLootTables.createAdditivePool(DISPENSER_ADDITIONS, 1)));
        if (!EBConfig.injectMobDrops) {
            return;
        }
        BuiltInRegistries.f_256780_.forEach(entityType -> {
            ResourceLocation lootTable = entityType.m_20677_();
            ResourceLocation entityName = BuiltInRegistries.f_256780_.m_7981_(entityType);
            if (Arrays.asList(EBConfig.modifiableMobs).contains(entityName)) {
                LOOT_INJECTIONS.add((Pair<ResourceLocation, LootPool>)Pair.of((Object)lootTable, (Object)EBLootTables.createAdditivePool(WizardryMainMod.location("entities/mob_additions"), 1)));
            } else if (!entityType.m_20674_().m_21609_()) {
                LOOT_INJECTIONS.add((Pair<ResourceLocation, LootPool>)Pair.of((Object)lootTable, (Object)EBLootTables.createAdditivePool(WizardryMainMod.location("entities/mob_additions"), 1)));
            }
        });
    }

    public static void applyInjections(BiConsumer<ResourceLocation, LootPool> injector) {
        if (LOOT_INJECTIONS.isEmpty()) {
            EBLootTables.initInjections();
        }
        LOOT_INJECTIONS.forEach(loot -> injector.accept((ResourceLocation)loot.getFirst(), (LootPool)loot.getSecond()));
    }

    private static LootPool createAdditivePool(ResourceLocation entry, int weight) {
        return LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)entry).m_79707_(weight).m_79711_(0)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79082_();
    }
}

