/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.registries;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.DeferredObject;
import com.binaris.wizardry.api.content.effect.CurseMobEffect;
import com.binaris.wizardry.api.content.util.RegisterFunction;
import com.binaris.wizardry.content.effect.ContainmentEffect;
import com.binaris.wizardry.content.effect.DecayMobEffect;
import com.binaris.wizardry.content.effect.EnfeeblementCurse;
import com.binaris.wizardry.content.effect.FireSkinMobEffect;
import com.binaris.wizardry.content.effect.FontOfManaMobEffect;
import com.binaris.wizardry.content.effect.FrostMobEffect;
import com.binaris.wizardry.content.effect.OakFleshMobEffect;
import com.binaris.wizardry.content.effect.ParalysisMobEffect;
import com.binaris.wizardry.content.effect.StaticAuraMobEffect;
import com.binaris.wizardry.content.effect.UndeathCurse;
import com.binaris.wizardry.content.effect.WardMobEffect;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;

public final class EBMobEffects {
    static Map<String, DeferredObject<MobEffect>> MOB_EFFECTS = new HashMap<String, DeferredObject<MobEffect>>();
    public static final DeferredObject<MobEffect> ARCANE_JAMMER = EBMobEffects.mobEffect("arcane_jammer", () -> new CurseMobEffect(MobEffectCategory.HARMFUL, 0));
    public static final DeferredObject<MobEffect> FROST = EBMobEffects.mobEffect("frost", FrostMobEffect::new);
    public static final DeferredObject<MobEffect> PARALYSIS = EBMobEffects.mobEffect("paralysis", ParalysisMobEffect::new);
    public static final DeferredObject<MobEffect> STATIC_AURA = EBMobEffects.mobEffect("static_aura", StaticAuraMobEffect::new);
    public static final DeferredObject<MobEffect> WARD = EBMobEffects.mobEffect("ward", WardMobEffect::new);
    public static final DeferredObject<MobEffect> FIRESKIN = EBMobEffects.mobEffect("fireskin", FireSkinMobEffect::new);
    public static final DeferredObject<MobEffect> OAKFLESH = EBMobEffects.mobEffect("oakflesh", OakFleshMobEffect::new);
    public static final DeferredObject<MobEffect> CURSE_OF_ENFEEBLEMENT = EBMobEffects.mobEffect("curse_of_enfeeblement", EnfeeblementCurse::new);
    public static final DeferredObject<MobEffect> CURSE_OF_UNDEATH = EBMobEffects.mobEffect("curse_of_undeath", UndeathCurse::new);
    public static final DeferredObject<MobEffect> DECAY = EBMobEffects.mobEffect("decay", DecayMobEffect::new);
    public static final DeferredObject<MobEffect> CONTAINMENT = EBMobEffects.mobEffect("containment", ContainmentEffect::new);
    public static final DeferredObject<MobEffect> FONT_OF_MANA = EBMobEffects.mobEffect("font_of_mana", FontOfManaMobEffect::new);
    public static final DeferredObject<MobEffect> CURSE_OF_SOULBINDING = EBMobEffects.mobEffect("curse_of_soulbinding", () -> new CurseMobEffect(MobEffectCategory.HARMFUL, 983055));

    public static void register(RegisterFunction<MobEffect> function) {
        MOB_EFFECTS.forEach((id, mobEffect) -> function.register(BuiltInRegistries.f_256974_, WizardryMainMod.location(id), (MobEffect)mobEffect.get()));
    }

    private static DeferredObject<MobEffect> mobEffect(String name, Supplier<MobEffect> effect) {
        DeferredObject<MobEffect> ret = new DeferredObject<MobEffect>(effect);
        MOB_EFFECTS.put(name, ret);
        return ret;
    }
}

