/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.registries;

import com.binaris.wizardry.setup.registries.EBItems;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.Item;

public final class WandUpgrades {
    static final HashMap<Item, String> UPGRADES = new HashMap();

    public static void initUpgrades() {
        WandUpgrades.register(EBItems.CONDENSER_UPGRADE.get(), "condenser");
        WandUpgrades.register(EBItems.STORAGE_UPGRADE.get(), "storage");
        WandUpgrades.register(EBItems.SIPHON_UPGRADE.get(), "siphon");
        WandUpgrades.register(EBItems.RANGE_UPGRADE.get(), "range");
        WandUpgrades.register(EBItems.DURATION_UPGRADE.get(), "duration");
        WandUpgrades.register(EBItems.COOLDOWN_UPGRADE.get(), "cooldown");
        WandUpgrades.register(EBItems.BLAST_UPGRADE.get(), "blast");
        WandUpgrades.register(EBItems.ATTUNEMENT_UPGRADE.get(), "attunement");
        WandUpgrades.register(EBItems.MELEE_UPGRADE.get(), "melee");
    }

    public static void register(Item upgrade, String identifier) {
        if (UPGRADES.containsValue(identifier)) {
            throw new IllegalArgumentException("Duplicate wand upgrade identifier: " + identifier);
        }
        UPGRADES.put(upgrade, identifier);
    }

    public static String getIdentifier(Item upgrade) {
        for (Map.Entry<Item, String> entry : UPGRADES.entrySet()) {
            if (!entry.getKey().equals(upgrade)) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("Wand upgrade not registered: " + String.valueOf(upgrade));
    }

    public static HashMap<Item, String> getWandUpgrades() {
        return UPGRADES;
    }

    public static Set<Item> getSpecialUpgrades() {
        return Collections.unmodifiableSet(WandUpgrades.getWandUpgrades().keySet());
    }

    public static boolean isWandUpgrade(Item upgrade) {
        return WandUpgrades.getWandUpgrades().keySet().stream().anyMatch(item -> item.equals(upgrade));
    }

    private WandUpgrades() {
    }
}

