/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.registries.client;

import com.binaris.wizardry.api.content.data.ConjureData;
import com.binaris.wizardry.core.mixin.accessor.ItemPropertiesAccessor;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.datagen.EBDataGenProcessor;
import com.binaris.wizardry.setup.registries.EBItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public final class EBItemProperties {
    private EBItemProperties() {
    }

    public static void register() {
        EBDataGenProcessor.wandItems().forEach((s, i) -> EBItemProperties.registerWandProperties((Item)i.get()));
        EBItemProperties.pullingItem(EBItems.FLAMECATCHER.get());
        EBItemProperties.conjureItem(EBItems.FLAMECATCHER.get());
        EBItemProperties.conjureItem(EBItems.FROST_AXE.get());
        EBItemProperties.conjureItem(EBItems.FLAMING_AXE.get());
        EBItemProperties.pullingItem(EBItems.SPECTRAL_BOW.get());
        EBItemProperties.conjureItem(EBItems.SPECTRAL_BOW.get());
    }

    private static void registerWandProperties(Item wand) {
        ItemPropertiesAccessor.callRegister(wand, new ResourceLocation("casting"), (stack, clientLevel, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
    }

    private static void pullingItem(Item item) {
        ItemPropertiesAccessor.callRegister(item, new ResourceLocation("pull"), (stack, clientLevel, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) / 20.0f;
        });
        ItemPropertiesAccessor.callRegister(item, new ResourceLocation("pulling"), (stack, clientLevel, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
    }

    private static void conjureItem(Item item) {
        ItemPropertiesAccessor.callRegister(item, new ResourceLocation("conjure"), (stack, clientLevel, entity, seed) -> {
            ConjureData data = Services.OBJECT_DATA.getConjureData(stack);
            if (data != null && data.isSummoned()) {
                int frames = 8;
                int damage = data.getRemainingLifetime(clientLevel.m_46467_());
                return damage < frames ? (float)damage / (float)frames : (float)(stack.m_41776_() - damage) / (float)frames;
            }
            return 0.0f;
        });
        ItemPropertiesAccessor.callRegister(item, new ResourceLocation("conjuring"), (stack, clientLevel, entity, seed) -> {
            ConjureData data = Services.OBJECT_DATA.getConjureData(stack);
            if (data != null && data.isSummoned()) {
                int frames = 8;
                int damage = data.getRemainingLifetime(clientLevel.m_46467_());
                return damage < frames || damage > stack.m_41776_() - frames ? 1.0f : 0.0f;
            }
            return 0.0f;
        });
    }
}

