/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.registries.client;

import com.binaris.wizardry.api.content.event.EBClientTickEvent;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.client.SpellGUIDisplay;
import com.binaris.wizardry.core.networking.c2s.ControlInputPacketC2S;
import com.binaris.wizardry.core.networking.c2s.SpellAccessPacketC2S;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.stream.IntStream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class EBKeyBinding {
    public static final String CATEGORY = "key.categories.ebwizardry";
    public static final KeyMapping NEXT_SPELL = new KeyMapping("key.ebwizardry.next_spell", InputConstants.Type.KEYSYM, 78, "key.categories.ebwizardry");
    public static final KeyMapping PREVIOUS_SPELL = new KeyMapping("key.ebwizardry.previous_spell", InputConstants.Type.KEYSYM, 66, "key.categories.ebwizardry");
    public static final KeyMapping[] SPELL_QUICK_ACCESS = new KeyMapping[8];
    static boolean nextSpellKeyPressed = false;
    static boolean previousSpellKeyPressed = false;
    static boolean[] quickAccessKeyPressed = new boolean[SPELL_QUICK_ACCESS.length];

    private EBKeyBinding() {
    }

    public static void onClientTick(EBClientTickEvent event) {
        LocalPlayer player = event.getMinecraft().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack wand = EntityUtil.getWandInUse((Player)player);
        if (wand == null) {
            return;
        }
        if (NEXT_SPELL.m_90857_() && Minecraft.m_91087_().f_91067_.m_91600_()) {
            if (!nextSpellKeyPressed) {
                nextSpellKeyPressed = true;
                EBKeyBinding.selectNextSpell(wand);
            }
        } else {
            nextSpellKeyPressed = false;
        }
        if (PREVIOUS_SPELL.m_90857_() && Minecraft.m_91087_().f_91067_.m_91600_()) {
            if (!previousSpellKeyPressed) {
                previousSpellKeyPressed = true;
                EBKeyBinding.selectPreviousSpell(wand);
            }
        } else {
            previousSpellKeyPressed = false;
        }
        for (int i = 0; i < SPELL_QUICK_ACCESS.length; ++i) {
            if (SPELL_QUICK_ACCESS[i].m_90857_() && Minecraft.m_91087_().f_91067_.m_91600_()) {
                if (quickAccessKeyPressed[i]) continue;
                EBKeyBinding.quickAccessKeyPressed[i] = true;
                EBKeyBinding.selectSpell(wand, i);
                continue;
            }
            EBKeyBinding.quickAccessKeyPressed[i] = false;
        }
    }

    public static void selectNextSpell(ItemStack wand) {
        ISpellCastingItem item = (ISpellCastingItem)wand.m_41720_();
        if (item.getCurrentSpell(wand) == Spells.NONE && item.getNextSpell(wand) == Spells.NONE) {
            return;
        }
        ControlInputPacketC2S msg = new ControlInputPacketC2S(ControlInputPacketC2S.ControlType.NEXT_SPELL_KEY);
        Services.NETWORK_HELPER.sendToServer(msg);
        if (Services.PLATFORM.getPlatformName().equals("Fabric")) {
            item.selectNextSpell(wand);
        }
        SpellGUIDisplay.playSpellSwitchAnimation(true);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)EBSounds.ITEM_WAND_SWITCH_SPELL.get(), (float)1.0f));
    }

    public static void selectPreviousSpell(ItemStack wand) {
        ISpellCastingItem item = (ISpellCastingItem)wand.m_41720_();
        if (item.getCurrentSpell(wand) == Spells.NONE && item.getPreviousSpell(wand) == Spells.NONE) {
            return;
        }
        ControlInputPacketC2S msg = new ControlInputPacketC2S(ControlInputPacketC2S.ControlType.PREVIOUS_SPELL_KEY);
        Services.NETWORK_HELPER.sendToServer(msg);
        if (Services.PLATFORM.getPlatformName().equals("Fabric")) {
            item.selectPreviousSpell(wand);
        }
        SpellGUIDisplay.playSpellSwitchAnimation(false);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)EBSounds.ITEM_WAND_SWITCH_SPELL.get(), (float)1.0f));
    }

    private static void selectSpell(ItemStack wand, int index) {
        ISpellCastingItem item = (ISpellCastingItem)wand.m_41720_();
        if (item.getCurrentSpell(wand) == Spells.NONE && item.getSpells(wand).length == 0) {
            return;
        }
        if (item.selectSpell(wand, index)) {
            SpellAccessPacketC2S msg = new SpellAccessPacketC2S(index);
            Services.NETWORK_HELPER.sendToServer(msg);
            SpellGUIDisplay.playSpellSwitchAnimation(true);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)EBSounds.ITEM_WAND_SWITCH_SPELL.get(), (float)1.0f));
        }
    }

    static {
        IntStream.range(0, SPELL_QUICK_ACCESS.length).forEach(i -> {
            EBKeyBinding.SPELL_QUICK_ACCESS[i] = new KeyMapping("key.ebwizardry.spell_" + (i + 1), InputConstants.Type.KEYSYM, -1, CATEGORY);
        });
    }
}

