/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.registries.client;

import com.binaris.wizardry.api.content.DeferredObject;
import com.binaris.wizardry.client.gui.screens.ArcaneWorkbenchScreen;
import com.binaris.wizardry.client.gui.screens.BookshelfScreen;
import com.binaris.wizardry.setup.registries.EBMenus;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public final class EBMenuScreens {
    private static final Map<DeferredObject<? extends MenuType<? extends AbstractContainerMenu>>, ScreenFactory<?, ?>> screens = Maps.newHashMap();

    private EBMenuScreens() {
    }

    public static void init() {
        EBMenuScreens.registerScreen(EBMenus.ARCANE_WORKBENCH_MENU, ArcaneWorkbenchScreen::new);
        EBMenuScreens.registerScreen(EBMenus.BOOKSHELF_MENU, BookshelfScreen::new);
    }

    private static <M extends AbstractContainerMenu, U extends Screen> void registerScreen(DeferredObject<? extends MenuType<M>> menuType, ScreenFactory<M, U> screenFactory) {
        screens.put(menuType, screenFactory);
    }

    public static void register(BiConsumer<MenuType<? extends AbstractContainerMenu>, ScreenFactory<AbstractContainerMenu, AbstractContainerScreen<AbstractContainerMenu>>> consumer) {
        screens.forEach((menuType, screenFactory) -> consumer.accept((MenuType<? extends AbstractContainerMenu>)((MenuType)menuType.get()), (ScreenFactory<AbstractContainerMenu, AbstractContainerScreen<AbstractContainerMenu>>)screenFactory));
    }

    @FunctionalInterface
    public static interface ScreenFactory<T extends AbstractContainerMenu, U extends Screen> {
        public U create(T var1, Inventory var2, Component var3);
    }
}

