/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.registries.client;

import com.binaris.wizardry.api.client.particle.ParticleWizardry;
import com.binaris.wizardry.api.content.DeferredObject;
import com.binaris.wizardry.client.particle.ParticleBeam;
import com.binaris.wizardry.client.particle.ParticleBuff;
import com.binaris.wizardry.client.particle.ParticleCloud;
import com.binaris.wizardry.client.particle.ParticleDarkMagic;
import com.binaris.wizardry.client.particle.ParticleDust;
import com.binaris.wizardry.client.particle.ParticleFlash;
import com.binaris.wizardry.client.particle.ParticleGuardianBeam;
import com.binaris.wizardry.client.particle.ParticleIce;
import com.binaris.wizardry.client.particle.ParticleLeaf;
import com.binaris.wizardry.client.particle.ParticleLightning;
import com.binaris.wizardry.client.particle.ParticleLightningPulse;
import com.binaris.wizardry.client.particle.ParticleMagicBubble;
import com.binaris.wizardry.client.particle.ParticleMagicFire;
import com.binaris.wizardry.client.particle.ParticlePath;
import com.binaris.wizardry.client.particle.ParticleScorch;
import com.binaris.wizardry.client.particle.ParticleSnow;
import com.binaris.wizardry.client.particle.ParticleSpark;
import com.binaris.wizardry.client.particle.ParticleSparkle;
import com.binaris.wizardry.client.particle.ParticleSphere;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;

public final class EBParticleProviders {
    static final Map<DeferredObject<SimpleParticleType>, Function<SpriteSet, ParticleProvider<SimpleParticleType>>> PARTICLE_PROVIDERS = new HashMap<DeferredObject<SimpleParticleType>, Function<SpriteSet, ParticleProvider<SimpleParticleType>>>();

    private EBParticleProviders() {
    }

    private static void registerParticle(DeferredObject<SimpleParticleType> particleType, BiFunction<ClientLevel, Vec3, ParticleWizardry> factory, Function<SpriteSet, ParticleProvider<SimpleParticleType>> provider) {
        PARTICLE_PROVIDERS.put(particleType, provider);
        ParticleWizardry.PROVIDERS.put(particleType.get(), factory);
    }

    public static void registerProvider(BiConsumer<DeferredObject<SimpleParticleType>, Function<SpriteSet, ParticleProvider<SimpleParticleType>>> function) {
        PARTICLE_PROVIDERS.forEach(function);
    }

    static {
        EBParticleProviders.registerParticle(EBParticles.BEAM, ParticleBeam.BeamProvider::createParticle, ParticleBeam.BeamProvider::new);
        EBParticleProviders.registerParticle(EBParticles.GUARDIAN_BEAM, ParticleGuardianBeam.GuardianBeamProvider::createParticle, ParticleGuardianBeam.GuardianBeamProvider::new);
        EBParticleProviders.registerParticle(EBParticles.BUFF, ParticleBuff.BuffProvider::createParticle, ParticleBuff.BuffProvider::new);
        EBParticleProviders.registerParticle(EBParticles.MAGIC_FIRE, ParticleMagicFire.MagicFireProvider::createParticle, ParticleMagicFire.MagicFireProvider::new);
        EBParticleProviders.registerParticle(EBParticles.SPARKLE, ParticleSparkle.SparkleProvider::createParticle, ParticleSparkle.SparkleProvider::new);
        EBParticleProviders.registerParticle(EBParticles.DARK_MAGIC, ParticleDarkMagic.DarkMagicProvider::createParticle, ParticleDarkMagic.DarkMagicProvider::new);
        EBParticleProviders.registerParticle(EBParticles.SNOW, ParticleSnow.SnowProvider::createParticle, ParticleSnow.SnowProvider::new);
        EBParticleProviders.registerParticle(EBParticles.LEAF, ParticleLeaf.LeafProvider::createParticle, ParticleLeaf.LeafProvider::new);
        EBParticleProviders.registerParticle(EBParticles.ICE, ParticleIce.IceProvider::createParticle, ParticleIce.IceProvider::new);
        EBParticleProviders.registerParticle(EBParticles.CLOUD, ParticleCloud.CloudProvider::createParticle, ParticleCloud.CloudProvider::new);
        EBParticleProviders.registerParticle(EBParticles.MAGIC_BUBBLE, ParticleMagicBubble.MagicBubbleProvider::createParticle, ParticleMagicBubble.MagicBubbleProvider::new);
        EBParticleProviders.registerParticle(EBParticles.SPARK, ParticleSpark.SparkProvider::createParticle, ParticleSpark.SparkProvider::new);
        EBParticleProviders.registerParticle(EBParticles.DUST, ParticleDust.DustProvider::createParticle, ParticleDust.DustProvider::new);
        EBParticleProviders.registerParticle(EBParticles.LIGHTNING_PULSE, ParticleLightningPulse.LightningPulseProvider::createParticle, ParticleLightningPulse.LightningPulseProvider::new);
        EBParticleProviders.registerParticle(EBParticles.SPHERE, ParticleSphere.SphereProvider::createParticle, ParticleSphere.SphereProvider::new);
        EBParticleProviders.registerParticle(EBParticles.FLASH, ParticleFlash.FlashProvider::createParticle, ParticleFlash.FlashProvider::new);
        EBParticleProviders.registerParticle(EBParticles.SCORCH, ParticleScorch.ScorchProvider::createParticle, ParticleScorch.ScorchProvider::new);
        EBParticleProviders.registerParticle(EBParticles.PATH, ParticlePath.PathProvider::createParticle, ParticlePath.PathProvider::new);
        EBParticleProviders.registerParticle(EBParticles.LIGHTNING, ParticleLightning.LightningProvider::createParticle, ParticleLightning.LightningProvider::new);
    }
}

