/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.registries.client;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.DeferredObject;
import com.binaris.wizardry.client.model.BoulderModel;
import com.binaris.wizardry.client.model.IceGiantModel;
import com.binaris.wizardry.client.model.RemnantModel;
import com.binaris.wizardry.client.model.WizardModel;
import com.binaris.wizardry.client.model.armor.RobeArmorModel;
import com.binaris.wizardry.client.model.armor.WizardArmorModel;
import com.binaris.wizardry.client.renderer.entity.BlankRenderer;
import com.binaris.wizardry.client.renderer.entity.BoulderRenderer;
import com.binaris.wizardry.client.renderer.entity.BubbleRenderer;
import com.binaris.wizardry.client.renderer.entity.ConjureArrowRenderer;
import com.binaris.wizardry.client.renderer.entity.DecayRenderer;
import com.binaris.wizardry.client.renderer.entity.EvilWizardRenderer;
import com.binaris.wizardry.client.renderer.entity.FireRingRenderer;
import com.binaris.wizardry.client.renderer.entity.ForceArrowRenderer;
import com.binaris.wizardry.client.renderer.entity.IceGiantRenderer;
import com.binaris.wizardry.client.renderer.entity.IceSpikeRenderer;
import com.binaris.wizardry.client.renderer.entity.MagicArrowRenderer;
import com.binaris.wizardry.client.renderer.entity.MagicProjectileRenderer;
import com.binaris.wizardry.client.renderer.entity.MeteorRenderer;
import com.binaris.wizardry.client.renderer.entity.RemnantRenderer;
import com.binaris.wizardry.client.renderer.entity.SigilRenderer;
import com.binaris.wizardry.client.renderer.entity.WizardRenderer;
import com.binaris.wizardry.client.renderer.entity.ZombieSpawnerRenderer;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.entity.BlazeRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.SlimeRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Blaze;
import org.jetbrains.annotations.NotNull;

public final class EBRenderers {
    private static final Map<DeferredObject<EntityType<? extends Entity>>, EntityRendererProvider<?>> providers = Maps.newHashMap();

    private EBRenderers() {
    }

    public static void createEntityLayers(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> consumer) {
        consumer.accept(WizardArmorModel.LAYER_LOCATION, WizardArmorModel::createBodyLayer);
        consumer.accept(RobeArmorModel.LAYER_LOCATION, RobeArmorModel::createBodyLayer);
        consumer.accept(RemnantModel.LAYER_LOCATION, RemnantModel::createBodyLayer);
        consumer.accept(WizardModel.LAYER_LOCATION, WizardModel::createBodyLayer);
        consumer.accept(IceGiantModel.LAYER_LOCATION, IceGiantModel::createBodyLayer);
        consumer.accept(BoulderModel.LAYER_LOCATION, BoulderModel::createBodyLayer);
    }

    public static void registerRenderers() {
        EBRenderers.registerEntityRender(EBEntities.METEOR, MeteorRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.ARROW_RAIN, BlankRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.FIRE_BOMB, ThrownItemRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.FIRE_BOMB, ThrownItemRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.SPARK_BOMB, ThrownItemRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.POISON_BOMB, ThrownItemRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.SMOKE_BOMB, ThrownItemRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.THUNDERBOLT, BlankRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.MAGIC_MISSILE, MagicArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.DART, MagicArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.ICE_SHARD, MagicArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.LIGHTNING_ARROW, MagicArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.ICE_LANCE, MagicArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.FORCE_ARROW, ForceArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.CONJURED_ARROW, ConjureArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.FLAME_CATCHER_ARROW, MagicArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.BLIZZARD, BlankRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.ICE_SPICKES, IceSpikeRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.TORNADO, BlankRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.BUBBLE, BubbleRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.HAILSTORM, BlankRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.DECAY, DecayRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.REMNANT, RemnantRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.WIZARD, WizardRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.EVIL_WIZARD, EvilWizardRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.ICE_GIANT, IceGiantRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.FIRE_BOLT, ctx -> new MagicProjectileRenderer(ctx, WizardryMainMod.location("textures/entity/firebolt.png")));
        EBRenderers.registerEntityRender(EBEntities.SPARK, ctx -> new MagicProjectileRenderer(ctx, WizardryMainMod.location("textures/entity/spark.png")));
        EBRenderers.registerEntityRender(EBEntities.ICE_CHARGE, ctx -> new MagicProjectileRenderer(ctx, WizardryMainMod.location("textures/entity/ice_charge.png")));
        EBRenderers.registerEntityRender(EBEntities.MAGIC_FIREBALL, ctx -> new MagicProjectileRenderer(ctx, WizardryMainMod.location("textures/entity/magic_fireball.png")));
        EBRenderers.registerEntityRender(EBEntities.ICE_BALL, ctx -> new MagicProjectileRenderer(ctx, WizardryMainMod.location("textures/entity/iceball.png")));
        EBRenderers.registerEntityRender(EBEntities.DARKNESS_ORB, ctx -> new MagicProjectileRenderer(ctx, WizardryMainMod.location("textures/entity/darkness_orb.png"), true));
        EBRenderers.registerEntityRender(EBEntities.FORCE_ORB, ctx -> new MagicProjectileRenderer(ctx, WizardryMainMod.location("textures/entity/force_orb.png"), true));
        EBRenderers.registerEntityRender(EBEntities.RING_OF_FIRE, ctx -> new FireRingRenderer(ctx, WizardryMainMod.location("textures/entity/ring_of_fire.png")));
        EBRenderers.registerEntityRender(EBEntities.FIRE_SIGIL, ctx -> new SigilRenderer(ctx, WizardryMainMod.location("textures/entity/fire_sigil.png"), 0.0f, true));
        EBRenderers.registerEntityRender(EBEntities.FROST_SIGIL, ctx -> new SigilRenderer(ctx, WizardryMainMod.location("textures/entity/frost_sigil.png"), 0.0f, true));
        EBRenderers.registerEntityRender(EBEntities.LIGHTNING_SIGIL, ctx -> new SigilRenderer(ctx, WizardryMainMod.location("textures/entity/lightning_sigil.png"), 0.0f, true));
        EBRenderers.registerEntityRender(EBEntities.HEAL_AURA, ctx -> new SigilRenderer(ctx, WizardryMainMod.location("textures/entity/healing_aura.png"), 0.3f, true));
        EBRenderers.registerEntityRender(EBEntities.COMBUSTION_RUNE, ctx -> new SigilRenderer(ctx, WizardryMainMod.location("textures/entity/combustion_rune.png"), 0.0f, true));
        EBRenderers.registerEntityRender(EBEntities.MAGIC_SLIME, SlimeRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.LIGHTNING_WRAITH, ctx -> new BlazeRenderer(ctx){

            @NotNull
            public ResourceLocation m_5478_(@NotNull Blaze entity) {
                return WizardryMainMod.location("textures/entity/lightning_wraith.png");
            }
        });
        EBRenderers.registerEntityRender(EBEntities.ICE_WRAITH, ctx -> new BlazeRenderer(ctx){

            @NotNull
            public ResourceLocation m_5478_(@NotNull Blaze entity) {
                return WizardryMainMod.location("textures/entity/ice_wraith.png");
            }
        });
        EBRenderers.registerEntityRender(EBEntities.SHADOW_WRAITH, BlankRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.STORM_ELEMENTAL, BlankRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.BOULDER, BoulderRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.ZOMBIE_SPAWNER, ZombieSpawnerRenderer::new);
    }

    public static Map<DeferredObject<EntityType<? extends Entity>>, EntityRendererProvider<?>> getRenderers() {
        return providers;
    }

    private static <T extends Entity> void registerEntityRender(DeferredObject<EntityType<T>> entityType, EntityRendererProvider provider) {
        providers.put(entityType, provider);
    }
}

