/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry;

import com.binaris.wizardry.api.content.effect.MagicMobEffect;
import com.binaris.wizardry.api.content.event.EBDiscoverSpellEvent;
import com.binaris.wizardry.api.content.event.EBEntityJoinLevelEvent;
import com.binaris.wizardry.api.content.event.EBItemPlaceInContainerEvent;
import com.binaris.wizardry.api.content.event.EBItemTossEvent;
import com.binaris.wizardry.api.content.event.EBLivingDeathEvent;
import com.binaris.wizardry.api.content.event.EBLivingHurtEvent;
import com.binaris.wizardry.api.content.event.EBLivingTick;
import com.binaris.wizardry.api.content.event.EBPlayerBreakBlockEvent;
import com.binaris.wizardry.api.content.event.EBPlayerInteractEntityEvent;
import com.binaris.wizardry.api.content.event.EBPlayerJoinServerEvent;
import com.binaris.wizardry.api.content.event.EBPlayerUseBlockEvent;
import com.binaris.wizardry.api.content.event.EBServerLevelLoadEvent;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.item.ArtefactItem;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.content.Forfeit;
import com.binaris.wizardry.content.data.SpellGlyphData;
import com.binaris.wizardry.content.effect.ContainmentEffect;
import com.binaris.wizardry.content.effect.FireSkinMobEffect;
import com.binaris.wizardry.content.effect.StaticAuraMobEffect;
import com.binaris.wizardry.content.effect.WardMobEffect;
import com.binaris.wizardry.content.entity.construct.BubbleConstruct;
import com.binaris.wizardry.content.item.WizardArmorItem;
import com.binaris.wizardry.content.spell.healing.FontOfMana;
import com.binaris.wizardry.content.spell.lightning.Charge;
import com.binaris.wizardry.content.spell.necromancy.CurseOfSoulbinding;
import com.binaris.wizardry.content.spell.sorcery.ArcaneLockSpell;
import com.binaris.wizardry.core.AllyDesignation;
import com.binaris.wizardry.core.DataEvents;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.setup.registries.EBAdvancementTriggers;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class EBEventHelper {
    private EBEventHelper() {
    }

    public static void register() {
        WizardryEventBus bus = WizardryEventBus.getInstance();
        EBEventHelper.onLivingHurtEvent(bus);
        EBEventHelper.onLivingTickEvent(bus);
        EBEventHelper.onSpellPreCast(bus);
        EBEventHelper.onSpellPostCast(bus);
        EBEventHelper.onServerLevelLoad(bus);
        EBEventHelper.onSpellTickCast(bus);
        EBEventHelper.onPlayerJoin(bus);
        EBEventHelper.onLivingDeathEvent(bus);
        EBEventHelper.onItemTossEvent(bus);
        EBEventHelper.onEntityJoinLevel(bus);
        EBEventHelper.onSpellDiscovery(bus);
        EBEventHelper.onPlayerInteractEntity(bus);
        EBEventHelper.onItemPlaceInContainer(bus);
        EBEventHelper.onPlayerUseBlock(bus);
        EBEventHelper.onPlayerBreakBlock(bus);
    }

    private static void onLivingHurtEvent(WizardryEventBus bus) {
        bus.register(EBLivingHurtEvent.class, Charge::onLivingHurt);
        bus.register(EBLivingHurtEvent.class, StaticAuraMobEffect::onLivingHurt);
        bus.register(EBLivingHurtEvent.class, FireSkinMobEffect::onLivingHurt);
        bus.register(EBLivingHurtEvent.class, CurseOfSoulbinding::onLivingHurt);
        bus.register(EBLivingHurtEvent.class, WardMobEffect::onLivingHurt);
        bus.register(EBLivingHurtEvent.class, BubbleConstruct::onLivingHurt);
        bus.register(EBLivingHurtEvent.class, ArtefactItem::onArtifactHurt);
        bus.register(EBLivingHurtEvent.class, AllyDesignation::onLivingHurt);
    }

    private static void onLivingTickEvent(WizardryEventBus bus) {
        bus.register(EBLivingTick.class, MagicMobEffect::onLivingTick);
        bus.register(EBLivingTick.class, ArtefactItem::onArtifactTick);
        bus.register(EBLivingTick.class, DataEvents::onMinionTick);
        bus.register(EBLivingTick.class, DataEvents::onPlayerTick);
        bus.register(EBLivingTick.class, ContainmentEffect::onLivingUpdateEvent);
    }

    private static void onSpellDiscovery(WizardryEventBus bus) {
        bus.register(EBDiscoverSpellEvent.class, event -> {
            if (!event.getPlayer().method_37908().field_9236) {
                EBAdvancementTriggers.DISCOVER_SPELL.trigger((class_3222)event.getPlayer(), event.getSpell(), event.getSource());
            }
        });
    }

    private static void onPlayerJoin(WizardryEventBus bus) {
        bus.register(EBPlayerJoinServerEvent.class, event -> SpellGlyphData.get((class_3218)event.getPlayer().method_37908()).sync((class_3222)event.getPlayer()));
        bus.register(EBPlayerJoinServerEvent.class, SpellProperties::onPlayerJoin);
    }

    private static void onServerLevelLoad(WizardryEventBus bus) {
        bus.register(EBServerLevelLoadEvent.class, SpellGlyphData::onServerLevelLoad);
    }

    private static void onEntityJoinLevel(WizardryEventBus bus) {
        bus.register(EBEntityJoinLevelEvent.class, DataEvents::onMinionJoinLevel);
    }

    private static void onItemTossEvent(WizardryEventBus bus) {
        bus.register(EBItemTossEvent.class, DataEvents::onConjureToss);
    }

    private static void onLivingDeathEvent(WizardryEventBus bus) {
        bus.register(EBLivingDeathEvent.class, ArtefactItem::onArtifactDeath);
        bus.register(EBLivingDeathEvent.class, DataEvents::onConjureEntityDeath);
    }

    private static void onItemPlaceInContainer(WizardryEventBus bus) {
        bus.register(EBItemPlaceInContainerEvent.class, DataEvents::onConjureItemPlaceInContainer);
    }

    private static void onSpellPreCast(WizardryEventBus bus) {
        bus.register(SpellCastEvent.Pre.class, WizardArmorItem::onSpellPreCast);
        bus.register(SpellCastEvent.Pre.class, Forfeit::onSpellCastPreEvent);
        bus.register(SpellCastEvent.Pre.class, ArtefactItem::onArtifactPreCast);
        bus.register(SpellCastEvent.Pre.class, EBEventHelper::castContextCheck);
        bus.register(SpellCastEvent.Pre.class, FontOfMana::onSpellCastPreEvent);
    }

    private static void onSpellPostCast(WizardryEventBus bus) {
        bus.register(SpellCastEvent.Post.class, Forfeit::onSpellCastPostEvent);
        bus.register(SpellCastEvent.Post.class, ArtefactItem::onArtifactPostCast);
    }

    private static void onSpellTickCast(WizardryEventBus bus) {
        bus.register(SpellCastEvent.Tick.class, WizardArmorItem::onSpellTickCast);
    }

    private static void onPlayerInteractEntity(WizardryEventBus bus) {
        bus.register(EBPlayerInteractEntityEvent.class, DataEvents::onPlayerInteractMinion);
    }

    private static void onPlayerUseBlock(WizardryEventBus bus) {
        bus.register(EBPlayerUseBlockEvent.class, ArcaneLockSpell::onPlayerUseBlock);
    }

    private static void onPlayerBreakBlock(WizardryEventBus bus) {
        bus.register(EBPlayerBreakBlockEvent.class, ArcaneLockSpell::onPlayerBreakBlock);
    }

    private static void castContextCheck(SpellCastEvent.Pre event) {
        boolean enabled;
        switch (event.getSource()) {
            case WAND: {
                boolean bl = event.getSpell().isEnabled(SpellContext.WANDS);
                break;
            }
            case SCROLL: {
                boolean bl = event.getSpell().isEnabled(SpellContext.SCROLL);
                break;
            }
            case COMMAND: {
                boolean bl = event.getSpell().isEnabled(SpellContext.COMMANDS);
                break;
            }
            case NPC: {
                boolean bl = event.getSpell().isEnabled(SpellContext.NPCS);
                break;
            }
            case DISPENSER: {
                boolean bl = event.getSpell().isEnabled(SpellContext.DISPENSERS);
                break;
            }
            default: {
                boolean bl = enabled = true;
            }
        }
        if (!enabled) {
            if (event.getCaster() != null && !event.getCaster().method_37908().field_9236) {
                event.getCaster().method_43496((class_2561)class_2561.method_43469((String)"spell.disabled", (Object[])new Object[]{event.getSpell().getDescriptionFormatted()}));
            }
            event.setCanceled(true);
        }
    }
}

