/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.client;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.DeferredObject;
import com.binaris.wizardry.client.ParticleSpawner;
import com.binaris.wizardry.core.networking.s2c.ParticleBuilderS2C;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public final class ParticleBuilder {
    private static final ParticleBuilder instance = new ParticleBuilder();
    private class_2400 particle;
    private class_1937 world;
    private boolean building;
    private int lifetime;
    private float scale;
    private double x;
    private double y;
    private double z;
    private float red;
    private float green;
    private float blue;
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private float fadeRed;
    private float fadeGreen;
    private float fadeBlue;
    private boolean shaded;
    private boolean gravity;
    private boolean serverAllowed;
    private long seed;
    private double length;
    private class_1297 entity;
    private float yaw;
    private float pitch;
    private double radius;
    private double rpt;
    private boolean collide;
    private double tx;
    private double ty;
    private double tz;
    private double tvx;
    private double tvy;
    private double tvz;
    private class_1297 target;

    public static ParticleBuilder create(DeferredObject<class_2400> particle) {
        return instance.particle(particle);
    }

    public static ParticleBuilder create(DeferredObject<class_2400> type, class_1297 entity) {
        double x = entity.field_6014 + (entity.method_37908().field_9229.method_43058() - 0.5) * (double)entity.method_17681();
        double y = entity.field_6036 + entity.method_37908().field_9229.method_43058() * (double)entity.method_17681();
        double z = entity.field_5969 + (entity.method_37908().field_9229.method_43058() - 0.5) * (double)entity.method_17681();
        return instance.particle(type).pos(x, y, z);
    }

    public static ParticleBuilder create(DeferredObject<class_2400> type, class_5819 random, double x, double y, double z, double radius) {
        double px = x + (random.method_43058() * 2.0 - 1.0) * radius;
        double py = y + (random.method_43058() * 2.0 - 1.0) * radius;
        double pz = z + (random.method_43058() * 2.0 - 1.0) * radius;
        return ParticleBuilder.create(type).pos(px, py, pz);
    }

    public static ParticleBuilder create(DeferredObject<class_2400> type, class_5819 random, double x, double y, double z, double radius, boolean move) {
        double px = x + (random.method_43058() * 2.0 - 1.0) * radius;
        double py = y + (random.method_43058() * 2.0 - 1.0) * radius;
        double pz = z + (random.method_43058() * 2.0 - 1.0) * radius;
        if (move) {
            return ParticleBuilder.create(type).pos(px, py, pz).velocity(px - x, py - y, pz - z);
        }
        return ParticleBuilder.create(type).pos(px, py, pz);
    }

    public static void spawnShockParticles(class_1937 world, double x, double y, double z) {
        for (int i = 0; i < 8; ++i) {
            double px = x + world.field_9229.method_43058() - 0.5;
            double py = y + world.field_9229.method_43058() + 0.5;
            double pz = z + world.field_9229.method_43058() - 0.5;
            ParticleBuilder.create(EBParticles.SPARK).pos(px, py, pz).spawn(world);
            px = x + world.field_9229.method_43058() - 0.5;
            py = y + world.field_9229.method_43058() - 0.5;
            pz = z + world.field_9229.method_43058() - 0.5;
            world.method_8406((class_2394)class_2398.field_11237, px, py, pz, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnHealParticles(class_1937 world, class_1309 entity) {
        for (int i = 0; i < 10; ++i) {
            double x = entity.method_23317() + world.field_9229.method_43058() * 2.0 - 1.0;
            double y = entity.method_23317() + (double)(entity.method_18377((class_4050)entity.method_18376()).field_18068 * 0.85f) - 0.5 + world.field_9229.method_43058();
            double z = entity.method_23317() + world.field_9229.method_43058() * 2.0 - 1.0;
            ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).velocity(0.0, 0.1, 0.0).color(1.0f, 1.0f, 0.3f).spawn(world);
        }
        ParticleBuilder.create(EBParticles.BUFF).entity((class_1297)entity).color(1.0f, 1.0f, 0.3f).spawn(world);
    }

    private ParticleBuilder particle(DeferredObject<class_2400> particle) {
        if (ParticleBuilder.instance.building) {
            EBLogger.warn("Attempted to build an already built particle: " + this.getCurrentParticleString(), new Object[0]);
            return instance;
        }
        this.particle = particle.get();
        this.building = true;
        return this;
    }

    private String getCurrentParticleString() {
        return String.format("[ Type: %s, Position: (%s, %s, %s), Velocity: (%s, %s, %s), Colour: (%s, %s, %s), Fade Colour: (%s, %s, %s), Radius: %s, Revs/tick: %s, Lifetime: %s, Gravity: %s, Shaded: %s, Scale: %s, Entity: %s ]", this.particle, this.x, this.y, this.z, this.velocityX, this.velocityY, this.velocityZ, Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.fadeRed), Float.valueOf(this.fadeGreen), Float.valueOf(this.fadeBlue), this.radius, this.rpt, this.lifetime, this.gravity, this.shaded, Float.valueOf(this.scale), this.entity);
    }

    public ParticleBuilder pos(double x, double y, double z) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public ParticleBuilder pos(class_2338 pos) {
        return this.pos(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public ParticleBuilder pos(class_243 vec3d) {
        return this.pos(vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215());
    }

    public ParticleBuilder time(int lifetime) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.lifetime = lifetime;
        return this;
    }

    public ParticleBuilder velocity(double velocityX, double velocityY, double velocityZ) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.velocityX = velocityX;
        this.velocityY = velocityY;
        this.velocityZ = velocityZ;
        return this;
    }

    public ParticleBuilder velocity(class_243 vel) {
        return this.velocity(vel.field_1352, vel.field_1351, vel.field_1350);
    }

    public ParticleBuilder scale(float scale) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.scale = scale;
        return this;
    }

    public ParticleBuilder color(float r, float g, float b) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.red = class_3532.method_15363((float)r, (float)0.0f, (float)1.0f);
        this.green = class_3532.method_15363((float)g, (float)0.0f, (float)1.0f);
        this.blue = class_3532.method_15363((float)b, (float)0.0f, (float)1.0f);
        return this;
    }

    public ParticleBuilder color(int r, int g, int b) {
        return this.color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public ParticleBuilder color(int hex) {
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        return this.color(r, g, b);
    }

    public ParticleBuilder fade(float r, float g, float b) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.fadeRed = class_3532.method_15363((float)r, (float)0.0f, (float)1.0f);
        this.fadeGreen = class_3532.method_15363((float)g, (float)0.0f, (float)1.0f);
        this.fadeBlue = class_3532.method_15363((float)b, (float)0.0f, (float)1.0f);
        return this;
    }

    public ParticleBuilder fade(int r, int g, int b) {
        return this.fade((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public ParticleBuilder fade(int hex) {
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        return this.fade(r, g, b);
    }

    public ParticleBuilder seed(long seed) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.seed = seed;
        return this;
    }

    public ParticleBuilder spin(double radius, double speed) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.radius = radius;
        this.rpt = speed;
        return this;
    }

    public ParticleBuilder collide(boolean collide) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.collide = collide;
        return this;
    }

    public ParticleBuilder entity(class_1297 entity) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.entity = entity;
        return this;
    }

    public ParticleBuilder face(float yaw, float pitch) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.yaw = yaw;
        this.pitch = pitch;
        return this;
    }

    public ParticleBuilder face(class_2350 direction) {
        return this.face(direction.method_10144(), direction.method_10166().method_10178() ? (float)(direction.method_10171().method_10181() * 90) : 0.0f);
    }

    public ParticleBuilder allowServer(boolean allow) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.serverAllowed = allow;
        return this;
    }

    public ParticleBuilder shaded(boolean value) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.shaded = value;
        return this;
    }

    public ParticleBuilder gravity(boolean value) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.gravity = value;
        return this;
    }

    public ParticleBuilder target(double x, double y, double z) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.tx = x;
        this.ty = y;
        this.tz = z;
        return this;
    }

    public ParticleBuilder target(class_243 pos) {
        return this.target(pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public ParticleBuilder tvel(double vx, double vy, double vz) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.tvx = vx;
        this.tvy = vy;
        this.tvz = vz;
        return this;
    }

    public ParticleBuilder tvel(class_243 vel) {
        return this.tvel(vel.field_1352, vel.field_1351, vel.field_1350);
    }

    public ParticleBuilder length(double length) {
        this.length = length;
        return this;
    }

    public ParticleBuilder target(class_1297 target) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.target = target;
        return this;
    }

    public void spawn(class_1937 world) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0 && this.entity == null) {
            EBLogger.error("Failed to spawn particle of type - %s - are you sure it exists?", new Object[0]);
        }
        if (this.serverAllowed && !world.method_8608()) {
            ParticleData data = this.captureData();
            ParticleBuilderS2C packet = new ParticleBuilderS2C(data);
            Services.NETWORK_HELPER.sendToDimension(world.method_8503(), packet, (class_5321<class_1937>)world.method_27983());
            this.reset();
            return;
        }
        if (!world.method_8608()) {
            EBLogger.error("ParticleBuilder.spawn(...) called on the server side! ParticleBuilder has prevented a server crash, but calling it on the server will do nothing. Consider adding a world.isClientSide() check or use .serverAllowed(true) to send particles to clients.", new Object[0]);
            this.reset();
            return;
        }
        ParticleSpawner.spawnClientParticle(this.captureData());
        this.reset();
    }

    private ParticleData captureData() {
        ParticleData data = new ParticleData();
        data.particleType = class_7923.field_41180.method_10221((Object)this.particle);
        data.x = this.x;
        data.y = this.y;
        data.z = this.z;
        data.vx = this.velocityX;
        data.vy = this.velocityY;
        data.vz = this.velocityZ;
        data.r = this.red;
        data.g = this.green;
        data.b = this.blue;
        data.fr = this.fadeRed;
        data.fg = this.fadeGreen;
        data.fb = this.fadeBlue;
        data.lifetime = this.lifetime;
        data.scale = this.scale;
        data.gravity = this.gravity;
        data.shaded = this.shaded;
        data.collide = this.collide;
        data.radius = this.radius;
        data.rpt = this.rpt;
        data.yaw = this.yaw;
        data.pitch = this.pitch;
        data.seed = this.seed;
        data.length = this.length;
        data.tx = this.tx;
        data.ty = this.ty;
        data.tz = this.tz;
        data.tvx = this.tvx;
        data.tvy = this.tvy;
        data.tvz = this.tvz;
        data.entityId = this.entity != null ? Integer.valueOf(this.entity.method_5628()) : null;
        data.targetId = this.target != null ? Integer.valueOf(this.target.method_5628()) : null;
        return data;
    }

    private void reset() {
        this.building = false;
        this.particle = null;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.velocityX = Double.NaN;
        this.velocityY = Double.NaN;
        this.velocityZ = Double.NaN;
        this.red = -1.0f;
        this.green = -1.0f;
        this.blue = -1.0f;
        this.fadeRed = -1.0f;
        this.fadeGreen = -1.0f;
        this.fadeBlue = -1.0f;
        this.radius = 0.0;
        this.rpt = 0.0;
        this.lifetime = -1;
        this.gravity = false;
        this.shaded = false;
        this.collide = false;
        this.scale = 1.0f;
        this.entity = null;
        this.yaw = Float.NaN;
        this.pitch = Float.NaN;
        this.tx = Double.NaN;
        this.ty = Double.NaN;
        this.tz = Double.NaN;
        this.tvx = Double.NaN;
        this.tvy = Double.NaN;
        this.tvz = Double.NaN;
        this.target = null;
        this.seed = 0L;
        this.length = -1.0;
        this.serverAllowed = false;
    }

    public static class ParticleData {
        public class_2960 particleType;
        public double x;
        public double y;
        public double z;
        public double vx;
        public double vy;
        public double vz;
        public float r;
        public float g;
        public float b;
        public float fr;
        public float fg;
        public float fb;
        public int lifetime;
        public float scale;
        public boolean gravity;
        public boolean shaded;
        public boolean collide;
        public double radius;
        public double rpt;
        public float yaw;
        public float pitch;
        public long seed;
        public double length;
        public double tx;
        public double ty;
        public double tz;
        public double tvx;
        public double tvy;
        public double tvz;
        public Integer entityId;
        public Integer targetId;

        public static ParticleData read(class_2540 buf) {
            ParticleData data = new ParticleData();
            data.particleType = buf.method_10810();
            data.x = buf.readDouble();
            data.y = buf.readDouble();
            data.z = buf.readDouble();
            data.vx = buf.readDouble();
            data.vy = buf.readDouble();
            data.vz = buf.readDouble();
            data.r = buf.readFloat();
            data.g = buf.readFloat();
            data.b = buf.readFloat();
            data.fr = buf.readFloat();
            data.fg = buf.readFloat();
            data.fb = buf.readFloat();
            data.lifetime = buf.readInt();
            data.scale = buf.readFloat();
            data.gravity = buf.readBoolean();
            data.shaded = buf.readBoolean();
            data.collide = buf.readBoolean();
            data.radius = buf.readDouble();
            data.rpt = buf.readDouble();
            data.yaw = buf.readFloat();
            data.pitch = buf.readFloat();
            data.seed = buf.readLong();
            data.length = buf.readDouble();
            data.tx = buf.readDouble();
            data.ty = buf.readDouble();
            data.tz = buf.readDouble();
            data.tvx = buf.readDouble();
            data.tvy = buf.readDouble();
            data.tvz = buf.readDouble();
            if (buf.readBoolean()) {
                data.entityId = buf.readInt();
            }
            if (buf.readBoolean()) {
                data.targetId = buf.readInt();
            }
            return data;
        }

        public void write(class_2540 buf) {
            buf.method_10812(this.particleType);
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeDouble(this.vx);
            buf.writeDouble(this.vy);
            buf.writeDouble(this.vz);
            buf.writeFloat(this.r);
            buf.writeFloat(this.g);
            buf.writeFloat(this.b);
            buf.writeFloat(this.fr);
            buf.writeFloat(this.fg);
            buf.writeFloat(this.fb);
            buf.writeInt(this.lifetime);
            buf.writeFloat(this.scale);
            buf.writeBoolean(this.gravity);
            buf.writeBoolean(this.shaded);
            buf.writeBoolean(this.collide);
            buf.writeDouble(this.radius);
            buf.writeDouble(this.rpt);
            buf.writeFloat(this.yaw);
            buf.writeFloat(this.pitch);
            buf.writeLong(this.seed);
            buf.writeDouble(this.length);
            buf.writeDouble(this.tx);
            buf.writeDouble(this.ty);
            buf.writeDouble(this.tz);
            buf.writeDouble(this.tvx);
            buf.writeDouble(this.tvy);
            buf.writeDouble(this.tvz);
            buf.writeBoolean(this.entityId != null);
            if (this.entityId != null) {
                buf.writeInt(this.entityId.intValue());
            }
            buf.writeBoolean(this.targetId != null);
            if (this.targetId != null) {
                buf.writeInt(this.targetId.intValue());
            }
        }
    }
}

