/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.client.particle;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.client.particle.ParticleWizardry;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5498;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParticleTargeted
extends ParticleWizardry {
    private static final double THIRD_PERSON_AXIAL_OFFSET = 1.2;
    protected double targetX;
    protected double targetY;
    protected double targetZ;
    protected double targetVelX;
    protected double targetVelY;
    protected double targetVelZ;
    protected double length;
    @Nullable
    protected class_1297 target = null;

    public ParticleTargeted(class_638 world, double x, double y, double z, class_4002 spriteProvider, boolean updateTextureOnTick) {
        super(world, x, y, z, spriteProvider, updateTextureOnTick);
    }

    @Override
    public void setTargetPosition(double x, double y, double z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    @Override
    public void setTargetVelocity(double vx, double vy, double vz) {
        this.targetVelX = vx;
        this.targetVelY = vy;
        this.targetVelZ = vz;
    }

    @Override
    public void setTargetEntity(class_1297 target) {
        this.target = target;
    }

    @Override
    public void setLength(double length) {
        this.length = length;
    }

    @Override
    public void method_3070() {
        super.method_3070();
        if (!(Double.isNaN(this.targetVelX) || Double.isNaN(this.targetVelY) || Double.isNaN(this.targetVelZ))) {
            this.targetX += this.targetVelX;
            this.targetY += this.targetVelY;
            this.targetZ += this.targetVelZ;
        }
    }

    private class_243 getPosition(class_1297 entity, double yOffset, float partialTick) {
        double d0 = class_3532.method_16436((double)partialTick, (double)entity.field_6038, (double)entity.method_23317());
        double d1 = class_3532.method_16436((double)partialTick, (double)entity.field_5971, (double)entity.method_23318()) + yOffset;
        double d2 = class_3532.method_16436((double)partialTick, (double)entity.field_5989, (double)entity.method_23321());
        return new class_243(d0, d1, d2);
    }

    @Override
    protected void updateEntityLinking(float partialTicks) {
    }

    @Override
    public void method_3074(@NotNull class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        double finalTargetZ;
        double finalTargetY;
        double finalTargetX;
        double originZ;
        double originY;
        double originX;
        class_1297 viewer = camera.method_19331();
        class_4587 stack = new class_4587();
        if (this.entity != null) {
            class_243 entityPos = this.getPosition(this.entity, 0.0, tickDelta);
            originX = entityPos.field_1352 + this.relativeX;
            originY = entityPos.field_1351 + this.relativeY;
            originZ = entityPos.field_1350 + this.relativeZ;
        } else {
            originX = class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874);
            originY = class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854);
            originZ = class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871);
        }
        if (this.entity != null && this.shouldApplyOriginOffset()) {
            boolean isFirstPerson;
            boolean bl = isFirstPerson = this.entity == viewer && class_310.method_1551().field_1690.method_31044() != class_5498.field_26666;
            if (!isFirstPerson || this.shouldApplyOriginOffsetInFirstPerson()) {
                class_243 look = this.entity.method_5828(tickDelta).method_1021(1.2);
                originX += look.field_1352;
                originY += look.field_1351;
                originZ += look.field_1350;
            }
        }
        if (this.target != null) {
            class_243 targetPos = this.getPosition(this.target, (double)this.target.method_17682() * 0.5, tickDelta);
            finalTargetX = targetPos.field_1352;
            finalTargetY = targetPos.field_1351;
            finalTargetZ = targetPos.field_1350;
        } else if (this.entity != null && this.length > 0.0) {
            class_243 look = this.entity.method_5828(tickDelta).method_1021(this.length);
            finalTargetX = originX + look.field_1352;
            finalTargetY = originY + look.field_1351;
            finalTargetZ = originZ + look.field_1350;
        } else {
            finalTargetX = this.targetX;
            finalTargetY = this.targetY;
            finalTargetZ = this.targetZ;
            if (!(Double.isNaN(this.targetVelX) || Double.isNaN(this.targetVelY) || Double.isNaN(this.targetVelZ))) {
                finalTargetX += (double)tickDelta * this.targetVelX;
                finalTargetY += (double)tickDelta * this.targetVelY;
                finalTargetZ += (double)tickDelta * this.targetVelZ;
            }
        }
        if (Double.isNaN(finalTargetX) || Double.isNaN(finalTargetY) || Double.isNaN(finalTargetZ)) {
            EBLogger.error("Attempted to render a targeted particle, but neither its target entity nor target position was set, and it either had no length assigned or was not linked to an entity.", new Object[0]);
            return;
        }
        stack.method_22903();
        stack.method_22904(originX - camera.method_19326().field_1352, originY - camera.method_19326().field_1351, originZ - camera.method_19326().field_1350);
        double dx = finalTargetX - originX;
        double dy = finalTargetY - originY;
        double dz = finalTargetZ - originZ;
        float beamLength = class_3532.method_15355((float)((float)(dx * dx + dy * dy + dz * dz)));
        class_243 direction = new class_243(dx, dy, dz).method_1029();
        float yaw = (float)(Math.atan2(direction.field_1352, direction.field_1350) * 180.0 / Math.PI);
        float pitch = (float)(Math.asin(-direction.field_1351) * 180.0 / Math.PI);
        stack.method_22907(class_7833.field_40716.rotationDegrees(yaw));
        stack.method_22907(class_7833.field_40714.rotationDegrees(pitch));
        class_289 tesselator = class_289.method_1348();
        this.draw(stack, tesselator, beamLength, tickDelta);
        stack.method_22909();
    }

    protected boolean shouldApplyOriginOffset() {
        return true;
    }

    protected boolean shouldApplyOriginOffsetInFirstPerson() {
        return false;
    }

    protected abstract void draw(class_4587 var1, class_289 var2, float var3, float var4);
}

