/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.client.particle;

import com.binaris.wizardry.api.content.entity.ICustomHitbox;
import com.binaris.wizardry.api.content.util.EntityUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParticleWizardry
extends class_4003 {
    public static final Map<class_2400, BiFunction<class_638, class_243, ParticleWizardry>> PROVIDERS = new LinkedHashMap<class_2400, BiFunction<class_638, class_243, ParticleWizardry>>();
    private static final double SPREAD_FACTOR = 0.2;
    private static final double IMPACT_FRICTION = 0.2;
    private final boolean updateTextureOnTick;
    protected long seed;
    protected Random random = new Random();
    protected boolean shaded = false;
    protected float initialRed;
    protected float initialGreen;
    protected float initialBlue;
    protected float fadeRed = 0.0f;
    protected float fadeGreen = 0.0f;
    protected float fadeBlue = 0.0f;
    protected float angle;
    protected double radius = 0.0;
    protected double speed = 0.0;
    @Nullable
    protected class_1297 entity = null;
    protected double relativeX;
    protected double relativeY;
    protected double relativeZ;
    protected double relativeMotionX;
    protected double relativeMotionY;
    protected double relativeMotionZ;
    protected float yaw = Float.NaN;
    protected float pitch = Float.NaN;
    protected boolean adjustQuadSize;
    class_4002 spriteSet;
    private double prevVelX;
    private double prevVelY;
    private double prevVelZ;

    public ParticleWizardry(class_638 world, double x, double y, double z, class_4002 spriteSet, boolean updateTextureOnTick) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.relativeX = this.field_3874;
        this.relativeY = this.field_3854;
        this.relativeZ = this.field_3871;
        this.updateTextureOnTick = updateTextureOnTick;
        this.method_18142(spriteSet);
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.random = new Random(seed);
    }

    public void setShaded(boolean shaded) {
        this.shaded = shaded;
    }

    public void setGravity(boolean gravity) {
        this.field_3844 = gravity ? 1.0f : 0.0f;
    }

    public void setCollisions(boolean canCollide) {
        this.field_3862 = canCollide;
    }

    public void method_34753(double velocityX, double velocityY, double velocityZ) {
        super.method_34753(velocityX, velocityY, velocityZ);
    }

    public void setSpin(double radius, double speed) {
        this.radius = radius;
        this.speed = speed * 2.0 * Math.PI;
        this.angle = this.random.nextFloat() * (float)Math.PI * 2.0f;
        this.field_3874 = this.relativeX - radius * (double)class_3532.method_15362((float)this.angle);
        this.field_3871 = this.relativeZ + radius * (double)class_3532.method_15374((float)this.angle);
        this.relativeMotionX = this.field_3852;
        this.relativeMotionY = this.field_3869;
        this.relativeMotionZ = this.field_3850;
    }

    public void setEntity(class_1297 entity) {
        this.entity = entity;
        if (entity != null) {
            this.method_3063(this.entity.field_6014 + this.relativeX, this.entity.field_6036 + this.relativeY, this.entity.field_5969 + this.relativeZ);
            this.field_3858 = this.field_3874;
            this.field_3838 = this.field_3854;
            this.field_3856 = this.field_3871;
            this.relativeMotionX = this.field_3852;
            this.relativeMotionY = this.field_3869;
            this.relativeMotionZ = this.field_3850;
        }
    }

    public void method_3084(float red, float green, float blue) {
        super.method_3084(red, green, blue);
        this.initialRed = red;
        this.initialGreen = green;
        this.initialBlue = blue;
        this.setFadeColour(red, green, blue);
    }

    public void setFadeColour(float r, float g, float b) {
        this.fadeRed = r;
        this.fadeGreen = g;
        this.fadeBlue = b;
    }

    public void setFacing(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public void setTargetPosition(double x, double y, double z) {
    }

    public void setTargetVelocity(double vx, double vy, double vz) {
    }

    public void setTargetEntity(class_1297 target) {
    }

    public void setLength(double length) {
    }

    @NotNull
    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    protected int method_3068(float f) {
        return this.shaded ? super.method_3068(f) : 0xF000F0;
    }

    public void method_3074(@NotNull class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        class_1297 viewer = camera.method_19331();
        this.updateEntityLinking(tickDelta);
        if (Float.isNaN(this.yaw) || Float.isNaN(this.pitch)) {
            super.method_3074(vertexConsumer, camera, tickDelta);
        } else {
            float degToRadFactor = (float)Math.PI / 180;
            float rotationX = class_3532.method_15362((float)(this.yaw * degToRadFactor));
            float rotationZ = class_3532.method_15374((float)(this.yaw * degToRadFactor));
            float rotationY = class_3532.method_15362((float)(this.pitch * degToRadFactor));
            float rotationYZ = -rotationZ * class_3532.method_15374((float)(this.pitch * degToRadFactor));
            float rotationXY = rotationX * class_3532.method_15374((float)(this.pitch * degToRadFactor));
            this.drawParticle(vertexConsumer, camera, tickDelta, rotationX, rotationY, rotationZ, rotationYZ, rotationXY);
        }
    }

    protected void drawParticle(class_4588 buffer, class_4184 camera, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        class_243 vec3 = camera.method_19326();
        float s = this.adjustQuadSize ? 0.1f : 1.0f;
        float f4 = s * this.method_18132(partialTicks);
        float f = this.method_18133();
        float f1 = this.method_18134();
        float f2 = this.method_18135();
        float f3 = this.method_18136();
        float f5 = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874) - vec3.method_10216());
        float f6 = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854) - vec3.method_10214());
        float f7 = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871) - vec3.method_10215());
        int i = this.method_3068(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        class_243[] avec3 = new class_243[]{new class_243((double)(-rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(-rotationYZ * f4 - rotationX * f4)), new class_243((double)(-rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(-rotationYZ * f4 + rotationXZ * f4)), new class_243((double)(rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(rotationYZ * f4 + rotationXZ * f4)), new class_243((double)(rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(rotationYZ * f4 - rotationXZ * f4))};
        if (this.angle != 0.0f) {
            float f8 = this.angle + (this.angle - this.field_3857) * partialTicks;
            float f9 = class_3532.method_15362((float)(f8 * 0.5f));
            float f10 = class_3532.method_15374((float)(f8 * 0.5f)) * camera.method_23767().x();
            float f11 = class_3532.method_15374((float)(f8 * 0.5f)) * camera.method_23767().y();
            float f12 = class_3532.method_15374((float)(f8 * 0.5f)) * camera.method_23767().z();
            class_243 vec3d = new class_243((double)f10, (double)f11, (double)f12);
            for (int l = 0; l < 4; ++l) {
                avec3[l] = vec3d.method_1021(2.0 * avec3[l].method_1026(vec3d)).method_1019(avec3[l].method_1021((double)(f9 * f9) - vec3d.method_1026(vec3d))).method_1019(vec3d.method_1036(avec3[l]).method_1021((double)(2.0f * f9)));
            }
        }
        buffer.method_22912((double)f5 + avec3[0].field_1352, (double)f6 + avec3[0].field_1351, (double)f7 + avec3[0].field_1350).method_22913(f1, f3).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22921(j, k).method_1344();
        buffer.method_22912((double)f5 + avec3[1].field_1352, (double)f6 + avec3[1].field_1351, (double)f7 + avec3[1].field_1350).method_22913(f1, f2).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22921(j, k).method_1344();
        buffer.method_22912((double)f5 + avec3[2].field_1352, (double)f6 + avec3[2].field_1351, (double)f7 + avec3[2].field_1350).method_22913(f, f2).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22921(j, k).method_1344();
        buffer.method_22912((double)f5 + avec3[3].field_1352, (double)f6 + avec3[3].field_1351, (double)f7 + avec3[3].field_1350).method_22913(f, f3).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22921(j, k).method_1344();
    }

    protected void updateEntityLinking(float partialTicks) {
        if (this.entity != null) {
            this.field_3874 = this.field_3874 + this.entity.field_6014 - this.entity.method_23317() - this.relativeMotionX * (double)(1.0f - partialTicks);
            this.field_3854 = this.field_3854 + this.entity.field_6036 - this.entity.method_23318() - this.relativeMotionY * (double)(1.0f - partialTicks);
            this.field_3871 = this.field_3871 + this.entity.field_5969 - this.entity.method_23321() - this.relativeMotionZ * (double)(1.0f - partialTicks);
        }
    }

    public void method_3070() {
        super.method_3070();
        if (this.field_3862 && this.field_3845) {
            this.field_3852 /= (double)0.7f;
            this.field_3850 /= (double)0.7f;
        }
        if (this.entity != null || this.radius > 0.0) {
            double x = this.relativeX;
            double y = this.relativeY;
            double z = this.relativeZ;
            if (this.entity != null) {
                if (!this.entity.method_5805()) {
                    this.method_3085();
                } else {
                    x += this.entity.method_23317();
                    y += this.entity.method_23318();
                    z += this.entity.method_23321();
                }
            }
            if (this.radius > 0.0) {
                this.angle += (float)this.speed;
                x += this.radius * (double)(-class_3532.method_15362((float)this.angle));
                z += this.radius * (double)class_3532.method_15374((float)this.angle);
            }
            this.method_3063(x, y, z);
            this.relativeX += this.relativeMotionX;
            this.relativeY += this.relativeMotionY;
            this.relativeZ += this.relativeMotionZ;
        }
        float ageFraction = (float)this.field_3866 / (float)this.field_3847;
        this.field_3861 = this.initialRed + (this.fadeRed - this.initialRed) * ageFraction;
        this.field_3842 = this.initialGreen + (this.fadeGreen - this.initialGreen) * ageFraction;
        this.field_3859 = this.initialBlue + (this.fadeBlue - this.initialBlue) * ageFraction;
        if (this.field_3862) {
            double searchRadius;
            List<class_1297> nearbyEntities;
            if (this.field_3852 == 0.0 && this.prevVelX != 0.0) {
                this.field_3869 *= 0.2;
                this.field_3850 *= 0.2;
                this.field_3869 += (this.random.nextDouble() * 2.0 - 1.0) * this.prevVelX * 0.2;
                this.field_3850 += (this.random.nextDouble() * 2.0 - 1.0) * this.prevVelX * 0.2;
            }
            if (this.field_3869 == 0.0 && this.prevVelY != 0.0) {
                this.field_3852 *= 0.2;
                this.field_3850 *= 0.2;
                this.field_3852 += (this.random.nextDouble() * 2.0 - 1.0) * this.prevVelY * 0.2;
                this.field_3850 += (this.random.nextDouble() * 2.0 - 1.0) * this.prevVelY * 0.2;
            }
            if (this.field_3850 == 0.0 && this.prevVelZ != 0.0) {
                this.field_3852 *= 0.2;
                this.field_3869 *= 0.2;
                this.field_3852 += (this.random.nextDouble() * 2.0 - 1.0) * this.prevVelZ * 0.2;
                this.field_3869 += (this.random.nextDouble() * 2.0 - 1.0) * this.prevVelZ * 0.2;
            }
            if ((nearbyEntities = EntityUtil.getEntitiesWithinRadius(searchRadius = 20.0, this.field_3874, this.field_3854, this.field_3871, (class_1937)this.field_3851, class_1297.class)).stream().anyMatch(e -> e instanceof ICustomHitbox && ((ICustomHitbox)e).calculateIntercept(new class_243(this.field_3874, this.field_3854, this.field_3871), new class_243(this.field_3874, this.field_3854, this.field_3871), 0.0f) != null)) {
                this.method_3085();
            }
        }
        this.prevVelX = this.field_3852;
        this.prevVelY = this.field_3869;
        this.prevVelZ = this.field_3850;
        if (this.updateTextureOnTick) {
            this.method_18142(this.spriteSet);
        }
    }

    public void method_3069(double dx, double dy, double dz) {
        double d0 = dx;
        double d1 = dy;
        double d2 = dz;
        if (this.field_3862 && (dx != 0.0 || dy != 0.0 || dz != 0.0) && dx * dx + dy * dy + dz * dz < class_3532.method_33723((double)100.0)) {
            class_243 vec3 = class_1297.method_20736(null, (class_243)new class_243(dx, dy, dz), (class_238)this.method_3064(), (class_1937)this.field_3851, List.of());
            dx = vec3.field_1352;
            dy = vec3.field_1351;
            dz = vec3.field_1350;
        }
        if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
            this.method_3067(this.method_3064().method_989(dx, dy, dz));
            this.method_3072();
        }
        boolean bl = this.field_3845 = d1 != dy && d1 < 0.0;
        if (d0 != dx) {
            this.field_3852 = 0.0;
        }
        if (d1 != dy) {
            this.field_3869 = 0.0;
        }
        if (d2 != dz) {
            this.field_3850 = 0.0;
        }
    }
}

