/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.client.util;

import com.binaris.wizardry.api.client.util.GlyphClientHandler;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.client.gui.screens.SpellBookScreen;
import com.binaris.wizardry.content.data.SpellGlyphData;
import com.binaris.wizardry.core.mixin.accessor.MerchantMenuAccessor;
import com.binaris.wizardry.core.networking.s2c.SpellGlyphPacketS2C;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1725;
import net.minecraft.class_1728;
import net.minecraft.class_1799;
import net.minecraft.class_1916;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_492;
import net.minecraft.class_5498;
import net.minecraft.class_746;

public class ClientUtils {
    public static boolean isFirstPerson(class_1297 entity) {
        return entity == class_310.method_1551().method_1560() && class_310.method_1551().field_1690.method_31044() == class_5498.field_26664;
    }

    public static boolean shouldDisplayDiscovered(Spell spell, @Nullable class_1799 stack) {
        class_1728 merchantMenu;
        class_1725 tradeContainer;
        class_1916 recipes;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        if (class_310.method_1551().field_1755 instanceof class_492 && (recipes = ((class_1728)((class_492)class_310.method_1551().field_1755).method_17577()).method_17438()).stream().anyMatch(r -> r.method_8250() == stack)) {
            return true;
        }
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof class_1728 && (tradeContainer = ((MerchantMenuAccessor)(merchantMenu = (class_1728)class_17032)).getTradeContainer()).method_5438(2) == stack) {
            return true;
        }
        if (player.method_7337()) {
            return true;
        }
        return Services.OBJECT_DATA.getSpellManagerData((class_1657)player).hasSpellBeenDiscovered(spell);
    }

    public static class_746 getPlayer() {
        return class_310.method_1551().field_1724;
    }

    public static void handleGlyphDataPacket(SpellGlyphPacketS2C message) {
        SpellGlyphData data = GlyphClientHandler.INSTANCE.getGlyphData();
        data.randomNames = new HashMap<Spell, String>();
        data.randomDescriptions = new HashMap<Spell, String>();
        for (Spell spell : Services.REGISTRY_UTIL.getSpells()) {
            class_2960 spellId = spell.getLocation();
            String name = message.getNames().get(spellId);
            String description = message.getDescriptions().get(spellId);
            if (name != null) {
                data.randomNames.put(spell, name);
            }
            if (description == null) continue;
            data.randomDescriptions.put(spell, description);
        }
    }

    public static class_2561 getScrollDisplayName(class_1799 scroll) {
        Spell spell = SpellUtil.getSpell(scroll);
        boolean discovered = ClientUtils.shouldDisplayDiscovered(spell, scroll);
        class_2561 name = discovered ? spell.getDescriptionFormatted() : SpellGlyphData.getGlyphNameFormatted(spell, GlyphClientHandler.INSTANCE.getGlyphData());
        return class_2561.method_43469((String)"item.ebwizardry.scroll", (Object[])new Object[]{name});
    }

    public static class_2561 getBookDisplayName(class_1799 book) {
        Spell spell = SpellUtil.getSpell(book);
        if (spell == Spells.NONE) {
            return class_2561.method_43471((String)"item.ebwizardry.spell_book.empty");
        }
        boolean discovered = ClientUtils.shouldDisplayDiscovered(spell, book);
        class_2561 name = discovered ? spell.getDescriptionFormatted() : SpellGlyphData.getGlyphNameFormatted(spell, GlyphClientHandler.INSTANCE.getGlyphData());
        return class_2561.method_43469((String)"item.ebwizardry.spell_book", (Object[])new Object[]{name});
    }

    public static void openSpellBook(class_1799 stack) {
        class_310.method_1551().method_1507((class_437)new SpellBookScreen(stack));
    }
}

