/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.data;

import com.binaris.wizardry.api.content.data.Persistence;
import java.util.function.BiFunction;
import net.minecraft.class_1657;
import net.minecraft.class_2540;

public interface ISpellVar<T> {
    public T update(class_1657 var1, T var2);

    public boolean isPersistent(boolean var1);

    public boolean isSynced();

    public void write(class_2540 var1, T var2);

    public T read(class_2540 var1);

    default public boolean canPurge(class_1657 player, T value) {
        return false;
    }

    public static class SpellVar<T>
    implements ISpellVar<T> {
        private final Persistence persistence;
        private BiFunction<class_1657, T, T> ticker = (p, t) -> t;

        public SpellVar(Persistence persistence) {
            this.persistence = persistence;
        }

        public SpellVar<T> withTicker(BiFunction<class_1657, T, T> ticker) {
            this.ticker = ticker;
            return this;
        }

        @Override
        public T update(class_1657 player, T value) {
            return this.ticker.apply(player, (class_1657)value);
        }

        @Override
        public boolean isPersistent(boolean respawn) {
            return respawn ? this.persistence.persistsOnRespawn() : this.persistence.persistsOnDimensionChange();
        }

        @Override
        public boolean isSynced() {
            return false;
        }

        @Override
        public void write(class_2540 buf, T value) {
        }

        @Override
        public T read(class_2540 buf) {
            return null;
        }
    }
}

