/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.data;

import com.binaris.wizardry.api.content.data.ISpellVar;
import com.binaris.wizardry.api.content.data.Persistence;
import com.binaris.wizardry.api.content.util.NBTExtras;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2512;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public interface IStoredSpellVar<T>
extends ISpellVar<T> {
    public void write(class_2487 var1, T var2);

    public T read(class_2487 var1);

    public static class StoredSpellVar<T, E extends class_2520>
    implements IStoredSpellVar<T> {
        private final String key;
        private final Persistence persistence;
        private final Function<T, E> serializer;
        private final Function<E, T> deserializer;
        private boolean synced;
        private BiFunction<class_1657, T, T> ticker = (p, t) -> t;

        public StoredSpellVar(String key, Function<T, E> serializer, Function<E, T> deserializer, Persistence persistence) {
            this.key = key;
            this.serializer = serializer;
            this.deserializer = deserializer;
            this.persistence = persistence;
        }

        public static StoredSpellVar<Byte, class_2481> ofByte(String key, Persistence persistence) {
            return new StoredSpellVar<Byte, class_2481>(key, class_2481::method_23233, class_2481::method_10698, persistence);
        }

        public static StoredSpellVar<Boolean, class_2481> ofBoolean(String key, Persistence persistence) {
            return new StoredSpellVar<Boolean, class_2481>(key, b -> class_2481.method_23233((byte)((byte)(b != false ? 1 : 0))), t -> t.method_10698() == 1, persistence);
        }

        public static StoredSpellVar<Integer, class_2497> ofInt(String key, Persistence persistence) {
            return new StoredSpellVar<Integer, class_2497>(key, class_2497::method_23247, class_2497::method_10701, persistence);
        }

        public static StoredSpellVar<int[], class_2495> ofIntArray(String key, Persistence persistence) {
            return new StoredSpellVar<int[], class_2495>(key, class_2495::new, class_2495::method_10588, persistence);
        }

        public static StoredSpellVar<Float, class_2494> ofFloat(String key, Persistence persistence) {
            return new StoredSpellVar<Float, class_2494>(key, class_2494::method_23244, class_2494::method_10700, persistence);
        }

        public static StoredSpellVar<Double, class_2489> ofDouble(String key, Persistence persistence) {
            return new StoredSpellVar<Double, class_2489>(key, class_2489::method_23241, class_2489::method_10697, persistence);
        }

        public static StoredSpellVar<Short, class_2516> ofShort(String key, Persistence persistence) {
            return new StoredSpellVar<Short, class_2516>(key, class_2516::method_23254, class_2516::method_10696, persistence);
        }

        public static StoredSpellVar<Long, class_2503> ofLong(String key, Persistence persistence) {
            return new StoredSpellVar<Long, class_2503>(key, class_2503::method_23251, class_2503::method_10699, persistence);
        }

        public static StoredSpellVar<String, class_2519> ofString(String key, Persistence persistence) {
            return new StoredSpellVar<String, class_2519>(key, class_2519::method_23256, class_2519::method_10714, persistence);
        }

        public static StoredSpellVar<class_2338, class_2487> ofBlockPos(String key, Persistence persistence) {
            return new StoredSpellVar<class_2338, class_2487>(key, class_2512::method_10692, class_2512::method_10691, persistence);
        }

        public static StoredSpellVar<UUID, class_2495> ofUUID(String key, Persistence persistence) {
            return new StoredSpellVar<UUID, class_2495>(key, class_2512::method_25929, class_2512::method_25930, persistence);
        }

        public static StoredSpellVar<class_2487, class_2487> ofNBT(String key, Persistence persistence) {
            return new StoredSpellVar<class_2487, class_2487>(key, t -> t, t -> t, persistence);
        }

        public StoredSpellVar<T, E> withTicker(BiFunction<class_1657, T, T> ticker) {
            this.ticker = ticker;
            return this;
        }

        public StoredSpellVar<T, E> setSynced() {
            this.synced = true;
            return this;
        }

        @Override
        public void write(class_2487 nbt, T value) {
            if (value != null) {
                NBTExtras.storeTagSafely(nbt, this.key, (class_2520)this.serializer.apply(value));
            }
        }

        @Override
        public T read(class_2487 nbt) {
            return nbt.method_10545(this.key) ? (T)this.deserializer.apply(nbt.method_10580(this.key)) : null;
        }

        @Override
        public T update(class_1657 player, T value) {
            return this.ticker.apply(player, (class_1657)value);
        }

        @Override
        public boolean isPersistent(boolean respawn) {
            return respawn ? this.persistence.persistsOnRespawn() : this.persistence.persistsOnDimensionChange();
        }

        @Override
        public boolean isSynced() {
            return this.synced;
        }

        @Override
        public void write(class_2540 buf, T value) {
            if (!this.synced) {
                return;
            }
            class_2487 nbt = new class_2487();
            this.write(nbt, value);
            buf.method_10794(nbt);
        }

        @Override
        public T read(class_2540 buf) {
            if (!this.synced) {
                return null;
            }
            class_2487 nbt = buf.method_10798();
            return nbt != null ? (T)this.read(nbt) : null;
        }
    }
}

