/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.entity.projectile;

import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.api.content.util.RayTracer;
import com.binaris.wizardry.core.AllyDesignation;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_8110;
import org.jetbrains.annotations.NotNull;

public abstract class MagicArrowEntity
extends class_1665 {
    public static final double LAUNCH_Y_OFFSET = 0.3;
    public static final float FORWARD_OFFSET = 0.1f;
    public static final int SEEKING_TIME = 15;
    public float damageMultiplier = 1.0f;
    protected int ticksInGround;
    protected int ticksInAir;

    public MagicArrowEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
    }

    public void aim(class_1309 caster, float speed) {
        if (this.method_24921() == null) {
            this.method_7432((class_1297)caster);
        }
        class_243 lookVector = caster.method_5720();
        this.method_5641(caster.field_6014 + lookVector.field_1352 * (double)0.1f, caster.method_23318() + (double)caster.method_18377((class_4050)caster.method_18376()).field_18068 - 0.3, caster.field_5969 + lookVector.field_1350 * (double)0.1f, caster.method_36454(), caster.method_36455());
        this.field_6014 -= (double)(class_3532.method_15362((float)(this.method_36454() / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_6036 -= (double)0.1f;
        this.field_5969 -= (double)(class_3532.method_15362((float)(this.method_36454() / 180.0f * (float)Math.PI)) * 0.16f);
        this.method_5814(this.field_6014, this.field_6036, this.field_5969);
        double motionX = -class_3532.method_15374((float)(this.method_36454() / 180.0f * (float)Math.PI)) * class_3532.method_15362((float)(this.method_36455() / 180.0f * (float)Math.PI));
        double motionY = -class_3532.method_15374((float)(this.method_36455() / 180.0f * (float)Math.PI));
        double motionZ = class_3532.method_15362((float)(this.method_36454() / 180.0f * (float)Math.PI)) * class_3532.method_15362((float)(this.method_36455() / 180.0f * (float)Math.PI));
        this.method_7485(motionX, motionY, motionZ, speed * 1.5f, 1.0f);
    }

    public void aim(class_1309 caster, class_1297 target, float speed, float aimingError) {
        if (this.method_24921() == null) {
            this.method_7432((class_1297)caster);
        }
        this.field_6036 = caster.field_6036 + (double)caster.method_18377((class_4050)caster.method_18376()).field_18068 * (double)0.85f - 0.3;
        double dx = target.field_6014 - caster.field_6014;
        double dy = !this.method_5740() ? target.field_6036 + (double)(target.method_18377((class_4050)caster.method_18376()).field_18068 / 3.0f) - this.field_6036 : target.field_6036 + (double)(target.method_18377((class_4050)caster.method_18376()).field_18068 / 2.0f) - this.field_6036;
        double dz = target.field_5969 - caster.field_5969;
        double horizontalDistance = class_3532.method_15355((float)((float)(dx * dx + dz * dz)));
        if (horizontalDistance >= 1.0E-7) {
            float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float pitch = (float)(-(Math.atan2(dy, horizontalDistance) * 180.0 / Math.PI));
            double dxNormalised = dx / horizontalDistance;
            double dzNormalised = dz / horizontalDistance;
            this.method_5641(caster.field_6014 + dxNormalised, this.field_6036, caster.field_5969 + dzNormalised, yaw, pitch);
            float bulletDropCompensation = !this.method_5740() ? (float)horizontalDistance * 0.2f : 0.0f;
            this.method_7485(dx, dy + (double)bulletDropCompensation, dz, speed, aimingError);
        }
    }

    protected void method_7454(@NotNull class_3966 hitResult) {
        class_1297 class_12972;
        class_1297 class_12973 = hitResult.method_17782();
        if (!(class_12973 instanceof class_1309)) {
            return;
        }
        class_1309 target = (class_1309)class_12973;
        if (MagicDamageSource.isEntityImmune(this.getDamageType(), (class_1297)target)) {
            this.method_31472();
            return;
        }
        class_1282 damageSource = this.method_24921() == null ? MagicDamageSource.causeDirectMagicDamage((class_1297)this, this.getDamageType()) : MagicDamageSource.causeIndirectMagicDamage((class_1297)this, this.method_24921(), this.getDamageType());
        target.method_5643(damageSource, (float)this.getDamage() * this.damageMultiplier);
        if (this.method_35207() > 0) {
            double knockback = Math.max(0.0, 1.0 - target.method_26825(class_5134.field_23718));
            class_243 vecKnockback = this.method_18798().method_18805(1.0, 0.0, 1.0).method_1029().method_1021((double)this.method_35207() * 0.6 * knockback);
            if (vecKnockback.method_1027() > 0.0) {
                target.method_5762(vecKnockback.field_1352, 0.1, vecKnockback.field_1350);
            }
        }
        if (!this.method_37908().field_9236 && (class_12972 = this.method_24921()) instanceof class_1309) {
            class_1309 arrowOwner = (class_1309)class_12972;
            class_1890.method_8210((class_1309)target, (class_1297)arrowOwner);
            class_1890.method_8213((class_1309)arrowOwner, (class_1297)target);
        }
        this.method_31472();
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("ticksInAir", this.ticksInAir);
        compound.method_10569("ticksInGround", this.ticksInGround);
        compound.method_10548("damageMultiplier", this.damageMultiplier);
    }

    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.ticksInAir = compound.method_10550("ticksInAir");
        this.ticksInGround = compound.method_10550("ticksInGround");
        this.damageMultiplier = compound.method_10583("damageMultiplier");
    }

    public abstract double getDamage();

    public abstract int getLifetime();

    public class_5321<class_8110> getDamageType() {
        return EBDamageSources.SORCERY;
    }

    public abstract class_2960 getTexture();

    @Deprecated
    public boolean doDeceleration() {
        return true;
    }

    @Deprecated
    public boolean doOverpenetration() {
        return false;
    }

    public float getSeekingStrength() {
        class_1657 player;
        class_1297 class_12972 = this.method_24921();
        return class_12972 instanceof class_1657 && EBAccessoriesIntegration.isEquipped(player = (class_1657)class_12972, EBItems.RING_SEEKING.get()) ? 2 : 0;
    }

    public void method_5773() {
        super.method_5773();
        if (this.getLifetime() >= 0 && this.field_6012 >= this.getLifetime()) {
            this.method_31472();
        }
        if (this.field_7588) {
            ++this.ticksInGround;
            this.tickInGround();
        } else {
            ++this.ticksInAir;
            this.ticksInAir();
        }
        if (this.getSeekingStrength() <= 0.0f) {
            return;
        }
        class_239 hit = RayTracer.rayTrace(this.method_37908(), (class_1297)this, this.method_19538(), this.method_19538().method_1019(this.method_18798().method_1021(15.0)), this.getSeekingStrength(), false, class_1309.class, RayTracer.ignoreEntityFilter(null));
        if (hit instanceof class_3966) {
            class_3966 entityHit = (class_3966)hit;
            class_1297 class_12972 = this.method_24921();
            if (class_12972 instanceof class_1309) {
                class_1309 entity;
                class_1309 owner = (class_1309)class_12972;
                class_12972 = entityHit.method_17782();
                if (class_12972 instanceof class_1309 && AllyDesignation.isValidTarget((class_1297)owner, (class_1297)(entity = (class_1309)class_12972))) {
                    class_243 direction = new class_243(entity.field_6014, entity.field_6036 + (double)(entity.method_18377((class_4050)entity.method_18376()).field_18068 / 2.0f), entity.field_5969).method_1020(this.method_19538()).method_1029().method_1021(this.method_18798().method_1033());
                    this.method_18799(this.method_18798().method_1019(direction.method_1020(this.method_18798()).method_1021(0.13333333333333333)));
                }
            }
        }
    }

    public void tickInGround() {
    }

    public void ticksInAir() {
    }

    protected boolean method_34713(@NotNull class_1657 player) {
        return false;
    }

    @NotNull
    protected class_3414 method_7440() {
        return class_3417.field_42593;
    }
}

